/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.widgets;

import java.util.LinkedHashMap;
import java.util.Map;
import journeymap.api.v2.client.option.KeyedEnum;
import journeymap.client.cartography.color.RGB;
import journeymap.client.ui.component.buttons.RadioButton;
import journeymap.client.ui.component.widgets.StringWidget;
import journeymap.common.properties.config.EnumField;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.network.chat.Component;

public class PropertiesRadioButtonListWidget<T extends Enum<?>>
extends LinearLayout {
    private static final int VERTICAL_PADDING = 3;
    private static final int HORIZONTAL_PADDING = 6;
    private final EnumField<T> values;
    private final int MAX_ROWS = 4;
    int columnCt = 1;
    private T enabledValue;
    private final Map<RadioButton, T> buttonValueMap;
    private final GridLayout buttonGrid;
    private final OnChange<T> onChange;

    public PropertiesRadioButtonListWidget(String titleKey, EnumField<T> values, OnChange<T> onChange) {
        super(0, 0, LinearLayout.Orientation.VERTICAL);
        this.onChange = onChange;
        this.addChild((LayoutElement)new Title(titleKey, Minecraft.getInstance().font, this), LayoutSettings::alignHorizontallyCenter);
        this.spacing(6);
        this.values = values;
        this.enabledValue = values.get();
        this.buttonValueMap = new LinkedHashMap<RadioButton, T>();
        this.buttonGrid = new GridLayout();
        this.buildButtonGrid();
    }

    void buildButtonGrid() {
        this.buttonGrid.rowSpacing(4);
        this.buttonGrid.columnSpacing(3);
        int row = 0;
        int column = 0;
        for (Enum value : this.values.getValidValues()) {
            if (row >= 4) {
                ++column;
                ++this.columnCt;
                row = 0;
            }
            KeyedEnum keyedEnum = (KeyedEnum)value;
            RadioButton button = new RadioButton(8, 8, (Component)Component.translatable((String)keyedEnum.getKey()), value == this.enabledValue, this::onPress);
            button.setTooltip(Tooltip.create((Component)Component.translatable((String)(keyedEnum.getKey() + ".tooltip"))));
            this.buttonValueMap.put(button, value);
            this.buttonGrid.addChild((LayoutElement)button, row++, column);
        }
        this.addChild((LayoutElement)this.buttonGrid, LayoutSettings::alignHorizontallyCenter);
    }

    private void onPress(Button button) {
        RadioButton radio = (RadioButton)button;
        this.buttonValueMap.forEach((b, t) -> b.setState(false));
        radio.setState(true);
        this.onChange.onChange((Enum)this.buttonValueMap.get((Object)radio));
    }

    protected void render(GuiGraphics graphics, int mouseX, int mouseY) {
        int startX = this.buttonGrid.getX() - 6;
        int startY = this.buttonGrid.getY() - 3;
        int width = startX + this.buttonGrid.getWidth() + 12;
        int height = startY + this.buttonGrid.getHeight() + 6;
        int color = RGB.toArgb(0x404040, 1.0f);
        graphics.hLine(startX, width, startY, color);
        graphics.hLine(startX, width, height, color);
        graphics.vLine(startX, startY, height, color);
        graphics.vLine(width, startY, height, color);
    }

    public static interface OnChange<T extends Enum> {
        public void onChange(T var1);
    }

    private static class Title
    extends StringWidget {
        private final PropertiesRadioButtonListWidget<?> parent;

        public Title(String key, Font font, PropertiesRadioButtonListWidget<?> parent) {
            super((Component)Component.translatable((String)key).withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.UNDERLINE), font);
            this.setTooltip(Tooltip.create((Component)Component.translatable((String)(key + ".tooltip"))));
            this.parent = parent;
        }

        @Override
        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.parent.render(guiGraphics, mouseX, mouseY);
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        }
    }
}

