/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.popupscreenbutton.simple;

import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class ConfirmationPopup
extends PopupButtonScreen<Boolean> {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.parse((String)"popup/background");
    private final LinearLayout layout = LinearLayout.vertical();
    private final Component confirm;
    private final Component cancel;

    public ConfirmationPopup(String messageKey, String confirmKey, String cancelKey) {
        super((Component)Component.translatable((String)messageKey));
        this.confirm = Component.translatable((String)confirmKey);
        this.cancel = Component.translatable((String)cancelKey);
        this.response = false;
    }

    public void init() {
        this.layout.spacing(12).defaultCellSetting().alignHorizontallyCenter();
        this.layout.addChild((LayoutElement)new MultiLineTextWidget((Component)this.title.copy().withStyle(ChatFormatting.BOLD), this.font).setMaxWidth(150).setCentered(true));
        LinearLayout bottomButtons = LinearLayout.horizontal();
        bottomButtons.spacing(12);
        bottomButtons.addChild((LayoutElement)Button.builder((Component)this.confirm, b -> this.setResponseAndClose(true)).width(this.font.width((FormattedText)this.confirm) + 10).build());
        bottomButtons.addChild((LayoutElement)Button.builder((Component)this.cancel, b -> this.setResponseAndClose(false)).width(this.font.width((FormattedText)this.cancel) + 10).build());
        this.layout.addChild((LayoutElement)bottomButtons);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    public void renderPopupScreenBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(graphics);
        graphics.blitSprite(BACKGROUND_SPRITE, this.layout.getX() - 18, this.layout.getY() - 18, this.layout.getWidth() + 36, this.layout.getHeight() + 36);
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)this.layout, (ScreenRectangle)this.getRectangle());
    }
}

