/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers;

import java.util.Collections;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.log.JMLogger;
import journeymap.client.log.StatTimer;
import journeymap.client.task.multi.MapPlayerTask;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.minimap.Effect;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.world.phys.Vec2;

public class HudOverlayHandler {
    private static final String DEBUG_PREFIX = String.valueOf(ChatFormatting.AQUA) + "[JM] " + String.valueOf(ChatFormatting.RESET);
    private static final String DEBUG_SUFFIX = "";
    private final Minecraft mc = Minecraft.getInstance();
    private long statTimerCheck;
    private List<String> statTimerReport = Collections.EMPTY_LIST;
    private static HudOverlayHandler instance;

    private HudOverlayHandler() {
    }

    public static HudOverlayHandler getInstance() {
        if (instance == null) {
            instance = new HudOverlayHandler();
        }
        return instance;
    }

    public boolean preOverlay(GuiGraphics graphics) {
        if (JourneymapClient.getInstance().enabled() && !Minecraft.getInstance().options.hideGui && Effect.getInstance().canPotionShift()) {
            Vec2 location = Effect.getInstance().getPotionEffectsLocation();
            graphics.pose().pushPose();
            graphics.pose().translate(location.x, location.y, 0.0f);
            return true;
        }
        return false;
    }

    public void postOverlay(GuiGraphics graphics) {
        if (JourneymapClient.getInstance().enabled()) {
            graphics.pose().popPose();
        }
    }

    public void onRenderOverlayDebug(List<String> leftText) {
        if (JourneymapClient.getInstance().enabled()) {
            try {
                if (this.mc.getDebugOverlay().showDebugScreen() && !"off".equalsIgnoreCase(JourneymapClient.getInstance().getCoreProperties().logLevel.get())) {
                    leftText.add(null);
                    if (JourneymapClient.getInstance().getCoreProperties().mappingEnabled.get().booleanValue()) {
                        for (String line : MapPlayerTask.getDebugStats()) {
                            leftText.add(DEBUG_PREFIX + line);
                        }
                    } else {
                        leftText.add(Constants.getString("jm.common.enable_mapping_false_text"));
                    }
                    if (this.mc.getDebugOverlay().showProfilerChart()) {
                        if (System.currentTimeMillis() - this.statTimerCheck > 3000L) {
                            this.statTimerReport = StatTimer.getReportByTotalTime(DEBUG_PREFIX, DEBUG_SUFFIX);
                            this.statTimerCheck = System.currentTimeMillis();
                        }
                        leftText.add(null);
                        leftText.addAll(this.statTimerReport);
                    }
                }
            }
            catch (Throwable t) {
                JMLogger.throwLogOnce("Unexpected error during onRenderOverlayEarly: " + String.valueOf(t), t);
            }
        }
    }

    public void renderWaypointDecos(GuiGraphics graphics) {
        if (JourneymapClient.getInstance().enabled() && (this.mc.screen == null || this.mc.screen instanceof ChatScreen) && this.mc.level != null) {
            try {
                UIManager.INSTANCE.drawWaypointDecorations(graphics);
            }
            catch (Throwable t) {
                JMLogger.throwLogOnce("Unexpected error during renderWaypointDecos: " + String.valueOf(t), t);
            }
        }
    }

    public void onRenderOverlay(GuiGraphics graphics) {
        if (JourneymapClient.getInstance().enabled() && this.mc.level != null && (this.mc.screen == null || this.mc.screen instanceof ChatScreen)) {
            try {
                if (!Minecraft.getInstance().options.hideGui) {
                    UIManager.INSTANCE.drawMiniMap(graphics);
                }
            }
            catch (Throwable t) {
                JMLogger.throwLogOnce("Unexpected error during onRenderOverlayEarly: " + String.valueOf(t), t);
            }
        }
    }
}

