/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.dispatchers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import journeymap.api.client.impl.ClientAPI;
import journeymap.api.client.impl.ThemeButtonDisplayFactory;
import journeymap.api.client.impl.ThemeToolbarDisplayFactory;
import journeymap.api.services.EventBus;
import journeymap.api.v2.client.entity.WrappedEntity;
import journeymap.api.v2.client.event.EntityRadarUpdateEvent;
import journeymap.api.v2.client.event.FullscreenDisplayEvent;
import journeymap.api.v2.client.event.PopupMenuEvent;
import journeymap.api.v2.client.fullscreen.CustomToolBarBuilder;
import journeymap.api.v2.client.fullscreen.IFullscreen;
import journeymap.api.v2.client.fullscreen.ModPopupMenu;
import journeymap.api.v2.client.fullscreen.ThemeButtonDisplay;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.client.model.entity.EntityDTO;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.theme.Theme;
import journeymap.client.ui.theme.ThemeButton;
import journeymap.client.ui.theme.ThemeToolbar;
import journeymap.client.waypoint.ClientWaypointImpl;

public class CustomEventDispatcher {
    private static CustomEventDispatcher INSTANCE;

    private CustomEventDispatcher() {
    }

    public static CustomEventDispatcher getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CustomEventDispatcher();
        }
        return INSTANCE;
    }

    public ThemeToolbar getMapTypeToolbar(Fullscreen fullscreen, Theme theme, Button ... buttons) {
        ThemeButtonDisplayFactory factory = new ThemeButtonDisplayFactory(theme);
        FullscreenDisplayEvent.MapTypeButtonDisplayEvent event = new FullscreenDisplayEvent.MapTypeButtonDisplayEvent((IFullscreen)fullscreen, (ThemeButtonDisplay)factory);
        EventBus.post(event);
        if (!factory.getThemeButtonList().isEmpty()) {
            ArrayList themeButtonList = Lists.newArrayList((Object[])buttons);
            factory.getThemeButtonList().forEach(fullscreen::addButtonWidget);
            themeButtonList.addAll(0, factory.getThemeButtonList());
            return new ThemeToolbar(theme, themeButtonList.toArray(new Button[0]));
        }
        return new ThemeToolbar(theme, buttons);
    }

    public ThemeToolbar getAddonToolbar(Fullscreen fullscreen, Theme theme) {
        ThemeButtonDisplayFactory factory = new ThemeButtonDisplayFactory(theme);
        FullscreenDisplayEvent.AddonButtonDisplayEvent event = new FullscreenDisplayEvent.AddonButtonDisplayEvent((IFullscreen)fullscreen, (ThemeButtonDisplay)factory);
        EventBus.post(event);
        if (!factory.getThemeButtonList().isEmpty()) {
            factory.getThemeButtonList().forEach(fullscreen::addButtonWidget);
            return new ThemeToolbar(theme, factory.getThemeButtonList().toArray(new ThemeButton[0]));
        }
        return null;
    }

    public List<ThemeToolbar> getCustomToolBars(Fullscreen fullscreen, Theme theme) {
        ThemeToolbarDisplayFactory factory = new ThemeToolbarDisplayFactory(theme, fullscreen);
        FullscreenDisplayEvent.CustomToolbarEvent event = new FullscreenDisplayEvent.CustomToolbarEvent((IFullscreen)fullscreen, (CustomToolBarBuilder)factory);
        EventBus.post(event);
        if (!factory.getToolbarList().isEmpty()) {
            factory.getToolbarList().forEach(bar -> bar.addAllButtons(fullscreen));
            return factory.getToolbarList();
        }
        return null;
    }

    public boolean popupWaypointMenuEvent(Fullscreen fullscreen, ModPopupMenu menu, ClientWaypointImpl wp) {
        PopupMenuEvent.WaypointPopupMenuEvent event = new PopupMenuEvent.WaypointPopupMenuEvent(menu, (IFullscreen)fullscreen, (Waypoint)wp);
        EventBus.post(event);
        return !event.isCancelled();
    }

    public boolean popupMenuEvent(Fullscreen fullscreen, ModPopupMenu menu) {
        PopupMenuEvent.FullscreenPopupMenuEvent event = new PopupMenuEvent.FullscreenPopupMenuEvent(menu, (IFullscreen)fullscreen);
        EventBus.post(event);
        return !event.isCancelled();
    }

    public boolean entityRadarPlayerUpdateEvent(EntityDTO dto) {
        return this.entityRadarUpdateEvent(EntityRadarUpdateEvent.EntityType.PLAYER, dto);
    }

    public boolean entityRadarMobUpdateEvent(EntityDTO dto) {
        return this.entityRadarUpdateEvent(EntityRadarUpdateEvent.EntityType.MOB, dto);
    }

    private boolean entityRadarUpdateEvent(EntityRadarUpdateEvent.EntityType type, EntityDTO dto) {
        EntityRadarUpdateEvent event = new EntityRadarUpdateEvent(ClientAPI.INSTANCE.getLastUIState(), type, (WrappedEntity)dto);
        EventBus.post(event);
        return !dto.isDisabled() && !event.isCancelled();
    }
}

