/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs.goals;

import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;

public class GenericProtectOwnerTargetGoal
extends TargetGoal {
    private final Supplier<LivingEntity> owner;
    private int intervalToCheck;
    private final int maxIntensity = 100;
    private int currentIntensity;

    public GenericProtectOwnerTargetGoal(Mob entity, Supplier<LivingEntity> getOwner) {
        super(entity, false);
        this.owner = getOwner;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        LivingEntity owner = this.owner.get();
        if (owner == null) {
            return false;
        }
        if (--this.intervalToCheck <= 0) {
            List entities = owner.level.getEntitiesOfClass(Mob.class, owner.getBoundingBox().inflate(16.0, 8.0, 16.0), mob -> {
                IMagicSummon summon;
                LivingEntity patt0$temp;
                return mob.getTarget() != null && (mob.getTarget().getUUID().equals(owner.getUUID()) || (patt0$temp = mob.getTarget()) instanceof IMagicSummon && (summon = (IMagicSummon)patt0$temp).getSummoner() != null && summon.getSummoner().getUUID().equals(owner.getUUID()));
            });
            if (entities.isEmpty()) {
                this.currentIntensity = Math.max(0, this.currentIntensity - 10);
                return false;
            }
            this.mob.setTarget((LivingEntity)entities.stream().min(Comparator.comparingDouble(o -> o.distanceToSqr((Entity)owner))).orElse((Mob)entities.getFirst()));
            return true;
        }
        int i = owner.getLastHurtByMobTimestamp();
        int tick = owner.tickCount;
        int combatIntervalModifier = Math.clamp((long)((tick - i) / 5), 0, 200);
        int intensityModifier = 100 - this.currentIntensity;
        this.intervalToCheck = 20 + combatIntervalModifier + intensityModifier;
        return false;
    }

    public void start() {
        this.currentIntensity = 100;
        super.start();
    }
}

