/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.loot;

import io.redspace.ironsjewelry.IronsJewelry;
import io.redspace.ironsjewelry.item.CurioBaseItem;
import io.redspace.ironsjewelry.utils.JewelryModTags;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;

@EventBusSubscriber
public class LootInjectionHandler {
    private static final int GEARSCORE_THRESHOLD = 30;
    private static final Map<Predicate<Item>, Integer> ITEM_GEARSCORES = LootInjectionHandler.createGearscoreMap();
    public static final HashMap<ResourceLocation, Float> TRACKED_LOOT_TABLES = new HashMap();
    private static boolean built;

    private static Map<Predicate<Item>, Integer> createGearscoreMap() {
        HashMap<Predicate<Item>, Integer> map = new HashMap<Predicate<Item>, Integer>();
        map.put(LootInjectionHandler.is(JewelryModTags.LOOT_HANDLER_LOW_GEARSCORE), 5);
        map.put(LootInjectionHandler.is(JewelryModTags.LOOT_HANDLER_MEDIUM_GEARSCORE), 25);
        map.put(LootInjectionHandler.is(JewelryModTags.LOOT_HANDLER_HIGH_GEARSCORE), 50);
        map.put(LootInjectionHandler.is(JewelryModTags.LOOT_HANDLER_VERY_HIGH_GEARSCORE), 75);
        map.put(item -> item instanceof ArmorItem || item instanceof SwordItem, 25);
        return map;
    }

    private static Predicate<Item> is(TagKey<Item> tag) {
        return item -> item.builtInRegistryHolder().is(tag);
    }

    private static int gearscoreFor(Item item) {
        for (Map.Entry<Predicate<Item>, Integer> gearscore : ITEM_GEARSCORES.entrySet()) {
            if (!gearscore.getKey().test(item)) continue;
            return gearscore.getValue();
        }
        return 0;
    }

    @SubscribeEvent
    public static void cacheTrackedLootTables(OnDatapackSyncEvent event) {
        if (!built || event.getPlayer() == null) {
            Registry lootTables = event.getPlayerList().getServer().reloadableRegistries().get().registryOrThrow(Registries.LOOT_TABLE);
            TRACKED_LOOT_TABLES.clear();
            for (Map.Entry registryEntry : lootTables.entrySet()) {
                LootInjectionHandler.handleLootTable(((ResourceKey)registryEntry.getKey()).location(), (LootTable)registryEntry.getValue());
            }
            built = true;
        }
    }

    private static void handleLootTable(ResourceLocation id, LootTable table) {
        try {
            ConstantValue cv;
            Object object;
            if (id.getNamespace().equals("irons_jewelry")) {
                return;
            }
            if (id.getPath().startsWith("blocks") || id.getPath().startsWith("entities") || id.getPath().startsWith("equipment")) {
                return;
            }
            if (table.pools.size() == 1 && (object = ((LootPool)table.pools.getFirst()).getRolls()) instanceof ConstantValue && (cv = (ConstantValue)object).value() == 1.0f) {
                return;
            }
            int gearscore = 0;
            for (LootPool pool : table.pools) {
                for (LootPoolEntryContainer entry : pool.entries) {
                    if (!(entry instanceof LootItem)) continue;
                    LootItem itemHolder = (LootItem)entry;
                    Holder item = itemHolder.item;
                    if (item.value() instanceof CurioBaseItem) {
                        return;
                    }
                    gearscore += LootInjectionHandler.gearscoreFor((Item)item.value());
                }
            }
            if (gearscore >= 30) {
                float chance = Mth.clampedLerp((float)0.025f, (float)0.5f, (float)((float)(gearscore - 30) / 750.0f));
                TRACKED_LOOT_TABLES.put(id, Float.valueOf(chance));
            }
        }
        catch (Exception e) {
            IronsJewelry.LOGGER.error("Failed to parse loot table \"{}\", skipping: {}", (Object)id, (Object)e.getMessage());
        }
    }
}

