/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.redspace.ironsjewelry.IronsJewelry;
import io.redspace.ironsjewelry.ServerConfig;
import io.redspace.ironsjewelry.loot.LootInjectionHandler;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class InjectJewelryLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<InjectJewelryLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(builder -> InjectJewelryLootModifier.codecStart((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, InjectJewelryLootModifier::new)));

    protected InjectJewelryLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        if (!((Boolean)ServerConfig.ENABLE_DYNAMIC_JEWELRY_LOOT.get()).booleanValue()) {
            return objectarraylist;
        }
        if (LootInjectionHandler.TRACKED_LOOT_TABLES.containsKey(context.getQueriedLootTableId())) {
            float chance = LootInjectionHandler.TRACKED_LOOT_TABLES.get(context.getQueriedLootTableId()).floatValue();
            if (context.getRandom().nextFloat() <= chance) {
                LootTable lootTable = context.getLevel().getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)IronsJewelry.id("modifiers/inject_jewelry")));
                lootTable.getRandomItemsRaw(context, arg_0 -> ((ObjectArrayList)objectarraylist).add(arg_0));
                generatedLoot.addAll((ObjectList)objectarraylist);
            }
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

