/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.blocks;

import ironfurnaces.init.Registration;
import ironfurnaces.tileentity.BlockWirelessEnergyHeaterTile;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;

public class BlockWirelessEnergyHeater
extends Block
implements EntityBlock {
    public static final String HEATER = "heater";

    public BlockWirelessEnergyHeater(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState(this.defaultBlockState());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_153215_, BlockState p_153216_) {
        return new BlockWirelessEnergyHeaterTile(p_153215_, p_153216_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockWirelessEnergyHeater.createTicker(level, type, Registration.HEATER_TILE.get());
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> p_152133_, BlockEntityType<E> p_152134_, BlockEntityTicker<? super E> p_152135_) {
        return p_152134_ == p_152133_ ? p_152135_ : null;
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level p_151988_, BlockEntityType<T> p_151989_, BlockEntityType<? extends BlockWirelessEnergyHeaterTile> p_151990_) {
        return p_151988_.isClientSide ? null : BlockWirelessEnergyHeater.createTickerHelper(p_151989_, p_151990_, BlockWirelessEnergyHeaterTile::tick);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!world.isClientSide) {
            BlockWirelessEnergyHeaterTile te = (BlockWirelessEnergyHeaterTile)world.getBlockEntity(pos);
            ItemStack stack = new ItemStack((ItemLike)Registration.HEATER.get());
            if (te.hasCustomName()) {
                stack.set(DataComponents.CUSTOM_NAME, (Object)te.getDisplayName());
            }
            if (te.getEnergy() > 0) {
                stack.set((DataComponentType)Registration.ENERGY.get(), (Object)te.getEnergy());
            }
            if (!player.isCreative()) {
                Containers.dropItemStack((Level)world, (double)te.getBlockPos().getX(), (double)te.getBlockPos().getY(), (double)te.getBlockPos().getZ(), (ItemStack)stack);
            }
        }
        return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity != null && world.getBlockEntity(pos) != null) {
            BlockWirelessEnergyHeaterTile te = (BlockWirelessEnergyHeaterTile)world.getBlockEntity(pos);
            if (stack.get(DataComponents.CUSTOM_NAME) != null) {
                te.setCustomName((Component)stack.get(DataComponents.CUSTOM_NAME));
            }
            int energy = (Integer)stack.getOrDefault((DataComponentType)Registration.ENERGY.get(), (Object)0);
            te.setEnergy(energy);
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult pHitResult) {
        return this.interactWith(level, pos, player, state);
    }

    private InteractionResult interactWith(Level level, BlockPos pos, Player player, BlockState state) {
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity be = level.getBlockEntity(pos);
            serverPlayer.openMenu((MenuProvider)be, buf -> buf.writeBlockPos(pos));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean p_196243_5_) {
        if (state.getBlock() != oldState.getBlock()) {
            BlockEntity te = world.getBlockEntity(pos);
            if (te instanceof BlockWirelessEnergyHeaterTile) {
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)((BlockWirelessEnergyHeaterTile)te));
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, oldState, p_196243_5_);
        }
    }
}

