/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SingleTransferMessage
implements CustomPacketPayload {
    public static CustomPacketPayload.Type<SingleTransferMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"inventoryessentials", (String)"single_transfer"));
    private final int slotNumber;

    public SingleTransferMessage(int slotNumber) {
        this.slotNumber = slotNumber;
    }

    public static SingleTransferMessage decode(FriendlyByteBuf buf) {
        byte slotNumber = buf.readByte();
        return new SingleTransferMessage(slotNumber);
    }

    public static void encode(FriendlyByteBuf buf, SingleTransferMessage message) {
        buf.writeByte(message.slotNumber);
    }

    public static void handle(ServerPlayer player, SingleTransferMessage message) {
        AbstractContainerMenu menu = player.containerMenu;
        if (menu != null && message.slotNumber >= 0 && message.slotNumber < menu.slots.size()) {
            Slot slot = (Slot)menu.slots.get(message.slotNumber);
            if (!slot.mayPickup((Player)player)) {
                return;
            }
            ItemStack sourceStack = slot.getItem();
            if (sourceStack.getCount() == 1) {
                menu.clicked(message.slotNumber, 0, ClickType.QUICK_MOVE, (Player)player);
            } else if (!sourceStack.isEmpty()) {
                ItemStack restStack = sourceStack.copy();
                sourceStack.setCount(1);
                slot.set(sourceStack);
                restStack.shrink(1);
                menu.clicked(message.slotNumber, 0, ClickType.QUICK_MOVE, (Player)player);
                if (!slot.hasItem()) {
                    slot.set(restStack);
                } else if (!player.addItem(restStack)) {
                    player.drop(restStack, false);
                }
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

