/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core.world;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.integratedtunnels.api.world.IBlockBreakHandler;

public class BlockBreakHandlerShulkerBox
implements IBlockBreakHandler {
    @Override
    public boolean shouldApply(BlockState blockState, Level world, BlockPos pos, Player player) {
        return true;
    }

    @Override
    public NonNullList<ItemStack> getDrops(BlockState blockState, Level world, BlockPos pos, Player player) {
        return BlockEntityHelpers.get((BlockGetter)world, (BlockPos)pos, ShulkerBoxBlockEntity.class).map(tile -> {
            if (!tile.isEmpty()) {
                ItemStack itemStack = ShulkerBoxBlock.getColoredItemStack((DyeColor)tile.getColor());
                tile.saveToItem(itemStack, (HolderLookup.Provider)world.registryAccess());
                if (tile.hasCustomName()) {
                    itemStack.set(DataComponents.CUSTOM_NAME, (Object)tile.getName());
                }
                NonNullList list = NonNullList.create();
                list.add((Object)itemStack);
                return list;
            }
            return NonNullList.create();
        }).orElseGet(NonNullList::create);
    }

    @Override
    public void breakBlock(BlockState blockState, Level world, BlockPos pos, Player player) {
        BlockEntityHelpers.get((BlockGetter)world, (BlockPos)pos, ShulkerBoxBlockEntity.class).ifPresent(BaseContainerBlockEntity::clearContent);
        blockState.getBlock().onDestroyedByPlayer(blockState, world, pos, player, false, world.getFluidState(pos));
    }
}

