/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.number;

import java.text.Format;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.impl.FormattedStringBuilder;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.impl.number.ConstantAffixModifier;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.impl.number.DecimalQuantity;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.impl.number.MicroProps;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.impl.number.MicroPropsGenerator;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.impl.number.Modifier;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.impl.number.MultiplierProducer;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.number.Notation;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.number.NumberFormatter;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.number.Precision;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.DecimalFormatSymbols;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.NumberFormat;

public class ScientificNotation
extends Notation {
    int engineeringInterval;
    boolean requireMinInt;
    int minExponentDigits;
    NumberFormatter.SignDisplay exponentSignDisplay;

    ScientificNotation(int engineeringInterval, boolean requireMinInt, int minExponentDigits, NumberFormatter.SignDisplay exponentSignDisplay) {
        this.engineeringInterval = engineeringInterval;
        this.requireMinInt = requireMinInt;
        this.minExponentDigits = minExponentDigits;
        this.exponentSignDisplay = exponentSignDisplay;
    }

    public ScientificNotation withMinExponentDigits(int minExponentDigits) {
        if (minExponentDigits >= 1 && minExponentDigits <= 999) {
            ScientificNotation other = this.createCopy();
            other.minExponentDigits = minExponentDigits;
            return other;
        }
        throw new IllegalArgumentException("Integer digits must be between 1 and 999 (inclusive)");
    }

    public ScientificNotation withExponentSignDisplay(NumberFormatter.SignDisplay exponentSignDisplay) {
        ScientificNotation other = this.createCopy();
        other.exponentSignDisplay = exponentSignDisplay;
        return other;
    }

    ScientificNotation createCopy() {
        return new ScientificNotation(this.engineeringInterval, this.requireMinInt, this.minExponentDigits, this.exponentSignDisplay);
    }

    MicroPropsGenerator withLocaleData(DecimalFormatSymbols symbols, boolean build, MicroPropsGenerator parent) {
        return new ScientificHandler(this, symbols, build, parent);
    }

    private static class ScientificHandler
    implements MicroPropsGenerator,
    MultiplierProducer,
    Modifier {
        final ScientificNotation notation;
        final DecimalFormatSymbols symbols;
        final ScientificModifier[] precomputedMods;
        final MicroPropsGenerator parent;
        int exponent;

        private ScientificHandler(ScientificNotation notation, DecimalFormatSymbols symbols, boolean safe, MicroPropsGenerator parent) {
            this.notation = notation;
            this.symbols = symbols;
            this.parent = parent;
            if (safe) {
                this.precomputedMods = new ScientificModifier[25];
                for (int i2 = -12; i2 <= 12; ++i2) {
                    this.precomputedMods[i2 + 12] = new ScientificModifier(i2, this);
                }
            } else {
                this.precomputedMods = null;
            }
        }

        @Override
        public MicroProps processQuantity(DecimalQuantity quantity) {
            int exponent;
            MicroProps micros = this.parent.processQuantity(quantity);
            assert (micros.rounder != null);
            if (quantity.isInfinite() || quantity.isNaN()) {
                micros.modInner = ConstantAffixModifier.EMPTY;
                return micros;
            }
            if (quantity.isZeroish()) {
                if (this.notation.requireMinInt && micros.rounder instanceof Precision.SignificantRounderImpl) {
                    ((Precision.SignificantRounderImpl)micros.rounder).apply(quantity, this.notation.engineeringInterval);
                    exponent = 0;
                } else {
                    micros.rounder.apply(quantity);
                    exponent = 0;
                }
            } else {
                exponent = -micros.rounder.chooseMultiplierAndApply(quantity, this);
            }
            if (this.precomputedMods != null && exponent >= -12 && exponent <= 12) {
                micros.modInner = this.precomputedMods[exponent + 12];
            } else if (this.precomputedMods != null) {
                micros.modInner = new ScientificModifier(exponent, this);
            } else {
                this.exponent = exponent;
                micros.modInner = this;
            }
            quantity.adjustExponent(exponent);
            micros.rounder = null;
            return micros;
        }

        @Override
        public int getMultiplier(int magnitude) {
            int interval = this.notation.engineeringInterval;
            int digitsShown = this.notation.requireMinInt ? interval : (interval <= 1 ? 1 : (magnitude % interval + interval) % interval + 1);
            return digitsShown - magnitude - 1;
        }

        @Override
        public int getPrefixLength() {
            return 0;
        }

        @Override
        public int getCodePointCount() {
            return 999;
        }

        @Override
        public boolean isStrong() {
            return true;
        }

        @Override
        public boolean containsField(Format.Field field) {
            assert (false);
            return false;
        }

        @Override
        public Modifier.Parameters getParameters() {
            assert (false);
            return null;
        }

        @Override
        public boolean semanticallyEquivalent(Modifier other) {
            assert (false);
            return false;
        }

        @Override
        public int apply(FormattedStringBuilder output, int leftIndex, int rightIndex) {
            return this.doApply(this.exponent, output, rightIndex);
        }

        private int doApply(int exponent, FormattedStringBuilder output, int rightIndex) {
            int i2 = rightIndex;
            i2 += output.insert(i2, this.symbols.getExponentSeparator(), NumberFormat.Field.EXPONENT_SYMBOL);
            if (exponent < 0 && this.notation.exponentSignDisplay != NumberFormatter.SignDisplay.NEVER) {
                i2 += output.insert(i2, this.symbols.getMinusSignString(), NumberFormat.Field.EXPONENT_SIGN);
            } else if (exponent >= 0 && this.notation.exponentSignDisplay == NumberFormatter.SignDisplay.ALWAYS) {
                i2 += output.insert(i2, this.symbols.getPlusSignString(), NumberFormat.Field.EXPONENT_SIGN);
            }
            int disp = Math.abs(exponent);
            for (int j2 = 0; j2 < this.notation.minExponentDigits || disp > 0; ++j2, disp /= 10) {
                int d2 = disp % 10;
                String digitString = this.symbols.getDigitStringsLocal()[d2];
                i2 += output.insert(i2 - j2, digitString, NumberFormat.Field.EXPONENT);
            }
            return i2 - rightIndex;
        }
    }

    private static class ScientificModifier
    implements Modifier {
        final int exponent;
        final ScientificHandler handler;

        ScientificModifier(int exponent, ScientificHandler handler) {
            this.exponent = exponent;
            this.handler = handler;
        }

        @Override
        public int apply(FormattedStringBuilder output, int leftIndex, int rightIndex) {
            return this.handler.doApply(this.exponent, output, rightIndex);
        }

        @Override
        public int getPrefixLength() {
            return 0;
        }

        @Override
        public int getCodePointCount() {
            return 999;
        }

        @Override
        public boolean isStrong() {
            return true;
        }

        @Override
        public boolean containsField(Format.Field field) {
            assert (false);
            return false;
        }

        @Override
        public Modifier.Parameters getParameters() {
            return null;
        }

        @Override
        public boolean semanticallyEquivalent(Modifier other) {
            if (!(other instanceof ScientificModifier)) {
                return false;
            }
            ScientificModifier _other = (ScientificModifier)other;
            return this.exponent == _other.exponent;
        }
    }
}

