/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.impl.number.parse;

import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.impl.StringSegment;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.impl.number.parse.ParsedNumber;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.impl.number.parse.SymbolMatcher;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.DecimalFormatSymbols;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.UnicodeSet;

public class NanMatcher
extends SymbolMatcher {
    private static final NanMatcher DEFAULT = new NanMatcher("NaN");

    public static NanMatcher getInstance(DecimalFormatSymbols symbols, int parseFlags) {
        String symbolString = symbols.getNaN();
        if (NanMatcher.DEFAULT.string.equals(symbolString)) {
            return DEFAULT;
        }
        return new NanMatcher(symbolString);
    }

    private NanMatcher(String symbolString) {
        super(symbolString, UnicodeSet.EMPTY);
    }

    @Override
    protected boolean isDisabled(ParsedNumber result) {
        return result.seenNumber();
    }

    @Override
    protected void accept(StringSegment segment, ParsedNumber result) {
        result.flags |= 0x40;
        result.setCharsConsumed(segment);
    }

    public String toString() {
        return "<NanMatcher>";
    }
}

