/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetASCII;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetMBCS;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetProviderICU;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetUTF32;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.UnicodeSet;

public abstract class CharsetICU
extends Charset {
    String icuCanonicalName;
    int options;
    float maxCharsPerByte;
    String name;
    int codepage;
    byte platform;
    byte conversionType;
    int minBytesPerChar;
    int maxBytesPerChar;
    byte[] subChar;
    byte subCharLen;
    byte hasToUnicodeFallback;
    byte hasFromUnicodeFallback;
    short unicodeMask;
    byte subChar1;
    public static final int ROUNDTRIP_SET = 0;
    @Deprecated
    public static final int ROUNDTRIP_AND_FALLBACK_SET = 1;
    private static final HashMap<String, String> algorithmicCharsets = new HashMap();

    protected CharsetICU(String icuCanonicalName, String canonicalName, String[] aliases) {
        super(canonicalName, aliases);
        if (canonicalName.length() == 0) {
            throw new IllegalCharsetNameException(canonicalName);
        }
        this.icuCanonicalName = icuCanonicalName;
    }

    @Override
    public boolean contains(Charset cs) {
        if (null == cs) {
            return false;
        }
        return this.equals(cs);
    }

    static final Charset getCharset(String icuCanonicalName, String javaCanonicalName, String[] aliases) {
        String className = algorithmicCharsets.get(icuCanonicalName);
        if (className == null) {
            className = "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetMBCS";
        }
        try {
            CharsetICU conv = null;
            Class<CharsetICU> cs = Class.forName(className).asSubclass(CharsetICU.class);
            Class[] paramTypes = new Class[]{String.class, String.class, String[].class};
            Constructor<CharsetICU> c2 = cs.getConstructor(paramTypes);
            Object[] params = new Object[]{icuCanonicalName, javaCanonicalName, aliases};
            try {
                conv = c2.newInstance(params);
                if (conv != null) {
                    return conv;
                }
            }
            catch (InvocationTargetException e2) {
                Throwable cause = e2.getCause();
                UnsupportedCharsetException e22 = new UnsupportedCharsetException(icuCanonicalName + ": Could not load " + className + ". Exception: " + String.valueOf(cause));
                e22.initCause(cause);
                throw e22;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        throw new UnsupportedCharsetException(icuCanonicalName + ": Could not load " + className);
    }

    static final boolean isSurrogate(int c2) {
        return (c2 & 0xFFFFF800) == 55296;
    }

    public static Charset forNameICU(String charsetName) throws IllegalCharsetNameException, UnsupportedCharsetException {
        CharsetProviderICU icuProvider = new CharsetProviderICU();
        CharsetICU cs = (CharsetICU)icuProvider.charsetForName(charsetName);
        if (cs != null) {
            return cs;
        }
        return Charset.forName(charsetName);
    }

    abstract void getUnicodeSetImpl(UnicodeSet var1, int var2);

    public void getUnicodeSet(UnicodeSet setFillIn, int which) {
        if (setFillIn == null || which != 0) {
            throw new IllegalArgumentException();
        }
        setFillIn.clear();
        this.getUnicodeSetImpl(setFillIn, which);
    }

    public boolean isFixedWidth() {
        if (this instanceof CharsetASCII || this instanceof CharsetUTF32) {
            return true;
        }
        return this instanceof CharsetMBCS && ((CharsetMBCS)this).sharedData.staticData.maxBytesPerChar == ((CharsetMBCS)this).sharedData.staticData.minBytesPerChar;
    }

    static void getNonSurrogateUnicodeSet(UnicodeSet setFillIn) {
        setFillIn.add(0, 55295);
        setFillIn.add(57344, 0x10FFFF);
    }

    static void getCompleteUnicodeSet(UnicodeSet setFillIn) {
        setFillIn.add(0, 0x10FFFF);
    }

    static {
        algorithmicCharsets.put("LMBCS-1", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-2", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-3", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-4", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-5", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-6", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-8", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-11", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-16", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-17", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-18", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-19", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("BOCU-1", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetBOCU1");
        algorithmicCharsets.put("SCSU", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetSCSU");
        algorithmicCharsets.put("US-ASCII", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetASCII");
        algorithmicCharsets.put("ISO-8859-1", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.Charset88591");
        algorithmicCharsets.put("UTF-16", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetUTF16");
        algorithmicCharsets.put("UTF-16BE", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetUTF16BE");
        algorithmicCharsets.put("UTF-16BE,version=1", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetUTF16BE");
        algorithmicCharsets.put("UTF-16LE", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetUTF16LE");
        algorithmicCharsets.put("UTF-16LE,version=1", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetUTF16LE");
        algorithmicCharsets.put("UTF16_OppositeEndian", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetUTF16LE");
        algorithmicCharsets.put("UTF16_PlatformEndian", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetUTF16");
        algorithmicCharsets.put("UTF-32", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetUTF32");
        algorithmicCharsets.put("UTF-32BE", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetUTF32BE");
        algorithmicCharsets.put("UTF-32LE", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetUTF32LE");
        algorithmicCharsets.put("UTF32_OppositeEndian", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetUTF32LE");
        algorithmicCharsets.put("UTF32_PlatformEndian", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetUTF32");
        algorithmicCharsets.put("UTF-8", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetUTF8");
        algorithmicCharsets.put("CESU-8", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetCESU8");
        algorithmicCharsets.put("UTF-7", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetUTF7");
        algorithmicCharsets.put("ISCII,version=0", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=1", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=2", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=3", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=4", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=5", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=6", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=7", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=8", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("IMAP-mailbox-name", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetUTF7");
        algorithmicCharsets.put("HZ", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetHZ");
        algorithmicCharsets.put("ISO_2022,locale=ja,version=0", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=ja,version=1", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=ja,version=2", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=ja,version=3", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=ja,version=4", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=zh,version=0", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=zh,version=1", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=zh,version=2", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=ko,version=0", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=ko,version=1", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("x11-compound-text", "org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.charset.CharsetCompoundText");
    }
}

