/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integratedscripting.RegistryEntries;

public class ItemScriptingDisk
extends Item {
    private static String NBT_KEY_ID = "integratedscripting:disk-key";

    public ItemScriptingDisk(Item.Properties properties) {
        super(properties);
    }

    public static int generateScriptingId() {
        return IntegratedDynamics.globalCounters.getNext("integratedscripting:scripting-ids");
    }

    public int getDiskId(ItemStack itemStack) {
        if (itemStack.getItem() instanceof ItemScriptingDisk && itemStack.has(RegistryEntries.DATACOMPONENT_DISK_ID)) {
            return (Integer)itemStack.get(RegistryEntries.DATACOMPONENT_DISK_ID);
        }
        return -1;
    }

    public int getOrCreateDiskId(ItemStack itemStack) {
        int id = this.getDiskId(itemStack);
        if (id < 0) {
            id = ItemScriptingDisk.generateScriptingId();
            itemStack.set(RegistryEntries.DATACOMPONENT_DISK_ID, (Object)id);
        }
        return id;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        int id = this.getDiskId(itemStack);
        if (id >= 0) {
            list.add((Component)Component.translatable((String)"item.integratedscripting.scripting_disk.id", (Object[])new Object[]{id}).withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        }
        if (id >= 0 && Minecraft.getInstance().player != null && Minecraft.getInstance().player.isCreative()) {
            list.add((Component)Component.translatable((String)"item.integrateddynamics.variable.warning"));
        }
        super.appendHoverText(itemStack, context, list, flag);
    }
}

