/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime.hotspot.libgraal;

import com.oracle.truffle.runtime.hotspot.libgraal.LibGraal;
import com.oracle.truffle.runtime.hotspot.libgraal.LibGraalIsolate;
import com.oracle.truffle.runtime.hotspot.libgraal.LibGraalTruffleCompilationSupport;
import java.util.concurrent.atomic.AtomicInteger;

public final class LibGraalScope
implements AutoCloseable {
    static final ThreadLocal<LibGraalScope> currentScope = new ThreadLocal();
    private final LibGraalScope parent;
    private final Shared shared;
    private static final AtomicInteger nextId = new AtomicInteger(1);
    private final int id;

    public static LibGraalScope current() {
        LibGraalScope scope = currentScope.get();
        if (scope == null) {
            throw new IllegalStateException("Not in an " + LibGraalScope.class.getSimpleName());
        }
        return scope;
    }

    public static long getIsolateThread() {
        return LibGraalScope.current().shared.getIsolateThread();
    }

    public LibGraalScope() {
        this(DetachAction.DETACH_RUNTIME);
    }

    public LibGraalScope(DetachAction detachAction) {
        boolean initializeIsolate;
        if (LibGraal.inLibGraal() || !LibGraal.isAvailable()) {
            throw new IllegalStateException();
        }
        this.id = nextId.getAndIncrement();
        this.parent = currentScope.get();
        if (this.parent == null) {
            long[] isolateBox = new long[]{0L};
            boolean firstAttach = LibGraal.attachCurrentThread(false, isolateBox);
            long isolateAddress = isolateBox[0];
            long isolateThread = LibGraalScope.getIsolateThreadIn(isolateAddress);
            long isolateId = LibGraalScope.getIsolateId(isolateThread);
            initializeIsolate = firstAttach;
            LibGraalIsolate isolate = LibGraalIsolate.forIsolateId(isolateId, isolateAddress);
            this.shared = new Shared(firstAttach ? detachAction : null, isolate, isolateThread);
        } else {
            this.shared = this.parent.shared;
            initializeIsolate = false;
        }
        currentScope.set(this);
        if (initializeIsolate) {
            LibGraalTruffleCompilationSupport.initializeIsolate(this.shared.getIsolateThread());
        }
    }

    public String toString() {
        return String.format("LibGraalScope@%d[%s, parent=%s]", this.id, this.shared, this.parent);
    }

    static native long attachThreadTo(long var0);

    static native void detachThreadFrom(long var0);

    static native long getIsolateThreadIn(long var0);

    private static native long getIsolateId(long var0);

    public LibGraalIsolate getIsolate() {
        return this.shared.isolate;
    }

    public long getIsolateThreadAddress() {
        return this.shared.getIsolateThread();
    }

    @Override
    public void close() {
        currentScope.set(this.parent);
        if (this.parent == null && this.shared.detachAction != null) {
            long isolateThread = this.shared.detach();
            if (this.shared.detachAction == DetachAction.DETACH) {
                LibGraalScope.detachThreadFrom(isolateThread);
            } else {
                LibGraal.detachCurrentThread(this.shared.detachAction == DetachAction.DETACH_RUNTIME_AND_RELEASE);
            }
        }
    }

    static class Shared {
        final DetachAction detachAction;
        final LibGraalIsolate isolate;
        private long isolateThread;

        Shared(DetachAction detachAction, LibGraalIsolate isolate, long isolateThread) {
            this.detachAction = detachAction;
            this.isolate = isolate;
            this.isolateThread = isolateThread;
        }

        public long getIsolateThread() {
            if (this.isolateThread == 0L) {
                throw new IllegalStateException(String.valueOf(Thread.currentThread()) + " is no longer attached to " + String.valueOf(this.isolate));
            }
            return this.isolateThread;
        }

        public long detach() {
            long res = this.getIsolateThread();
            this.isolateThread = 0L;
            return res;
        }

        public String toString() {
            return String.format("isolate=%s, isolateThread=0x%x, detachAction=%s", new Object[]{this.isolate, this.isolateThread, this.detachAction});
        }
    }

    public static enum DetachAction {
        DETACH,
        DETACH_RUNTIME,
        DETACH_RUNTIME_AND_RELEASE;

    }
}

