/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime.collection;

import com.oracle.truffle.runtime.collection.SerialQueue;
import java.util.Arrays;

public final class ArrayQueue<E>
implements SerialQueue<E> {
    private static final int INITIAL_SIZE = 128;
    private Object[] items = new Object[128];
    private int start = 0;
    private int tail = 0;

    private void ensureIndex(int n2) {
        if (n2 >= this.items.length) {
            int factor = 1;
            if (this.tail - this.start > this.items.length / 2) {
                factor = 2;
            }
            Object[] nitems = new Object[this.items.length * factor];
            System.arraycopy(this.items, this.start, nitems, 0, this.tail - this.start);
            this.items = nitems;
            this.tail -= this.start;
            this.start = 0;
        }
    }

    @Override
    public void add(E x2) {
        if (x2 == null) {
            throw new NullPointerException();
        }
        this.ensureIndex(this.tail);
        this.items[this.tail] = x2;
        ++this.tail;
    }

    @Override
    public E poll() {
        if (this.start == this.tail) {
            return null;
        }
        Object result = this.items[this.start];
        ++this.start;
        return (E)result;
    }

    @Override
    public E peek() {
        return (E)this.items[this.start];
    }

    @Override
    public void clear() {
        this.items = new Object[128];
        this.start = 0;
        this.tail = 0;
    }

    @Override
    public int size() {
        return this.tail - this.start;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.tail - this.start];
        System.arraycopy(this.items, this.start, result, 0, this.tail - this.start);
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        T[] result = Arrays.copyOf(this.items, this.tail - this.start, a2.getClass());
        return result;
    }

    @Override
    public int internalCapacity() {
        return this.items.length - this.size();
    }
}

