/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.runtime.OptimizedCallTarget;
import com.oracle.truffle.runtime.OptimizedRuntimeAccessor;
import com.oracle.truffle.runtime.TruffleSplittingStrategy;

@NodeInfo
public final class OptimizedDirectCallNode
extends DirectCallNode {
    private int callCount;
    private boolean inliningForced;
    @CompilerDirectives.CompilationFinal
    private Class<? extends Throwable> exceptionProfile;
    @CompilerDirectives.CompilationFinal
    private OptimizedCallTarget currentCallTarget;
    private volatile boolean splitDecided;

    OptimizedDirectCallNode(OptimizedCallTarget target) {
        super(target);
        assert (target.isSourceCallTarget());
        this.currentCallTarget = target;
    }

    @Override
    public Object call(Object ... arguments) {
        OptimizedCallTarget target = this.getCurrentCallTarget();
        if (CompilerDirectives.hasNextTier()) {
            this.incrementCallCount();
        }
        if (HostCompilerDirectives.inInterpreterFastPath()) {
            target = this.onInterpreterCall(target);
        }
        try {
            return target.callDirect(this, arguments);
        }
        catch (Throwable t2) {
            throw this.handleException(t2);
        }
    }

    private RuntimeException handleException(Throwable t2) {
        Throwable profiled = this.profileExceptionType(t2);
        OptimizedRuntimeAccessor.LANGUAGE.addStackFrameInfo(this, null, profiled, null);
        throw OptimizedCallTarget.rethrow(profiled);
    }

    private <T extends Throwable> T profileExceptionType(T value) {
        Class<? extends Throwable> clazz = this.exceptionProfile;
        if (clazz != Throwable.class) {
            if (clazz != null && value.getClass() == clazz) {
                if (CompilerDirectives.inInterpreter()) {
                    return value;
                }
                return (T)CompilerDirectives.castExact(value, clazz);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.exceptionProfile = clazz == null ? value.getClass() : Throwable.class;
        }
        return value;
    }

    @Override
    public boolean isInlinable() {
        CompilerAsserts.neverPartOfCompilation();
        return true;
    }

    @Override
    public void forceInlining() {
        CompilerAsserts.neverPartOfCompilation();
        this.inliningForced = true;
    }

    @Override
    public boolean isInliningForced() {
        CompilerAsserts.neverPartOfCompilation();
        return this.inliningForced;
    }

    @Override
    public boolean isCallTargetCloningAllowed() {
        return this.getCallTarget().getRootNode().isCloningAllowed();
    }

    public int getCallCount() {
        return this.callCount;
    }

    @Override
    public OptimizedCallTarget getCurrentCallTarget() {
        return this.currentCallTarget;
    }

    public int getKnownCallSiteCount() {
        return this.getCurrentCallTarget().getKnownCallSiteCount();
    }

    @Override
    public OptimizedCallTarget getClonedCallTarget() {
        if (this.currentCallTarget != this.callTarget) {
            return this.currentCallTarget;
        }
        return null;
    }

    @Override
    public OptimizedCallTarget getCallTarget() {
        return (OptimizedCallTarget)super.getCallTarget();
    }

    private OptimizedCallTarget onInterpreterCall(OptimizedCallTarget target) {
        if (target.isNeedsSplit() && !this.splitDecided) {
            this.splitDecided = true;
            TruffleSplittingStrategy.beforeCall(this, target);
            return this.getCurrentCallTarget();
        }
        return target;
    }

    private void incrementCallCount() {
        int calls = this.callCount;
        this.callCount = calls == Integer.MAX_VALUE ? calls : ++calls;
    }

    void split() {
        CompilerAsserts.neverPartOfCompilation();
        this.atomic(() -> {
            if (this.currentCallTarget != this.callTarget) {
                return;
            }
            assert (this.isCallTargetCloningAllowed());
            OptimizedCallTarget currentTarget = this.getCallTarget();
            OptimizedCallTarget splitTarget = currentTarget.cloneUninitialized();
            currentTarget.removeDirectCallNode(this);
            splitTarget.addDirectCallNode(this);
            assert (splitTarget.getCallSiteForSplit() == this);
            if (this.getParent() != null) {
                this.replace(this, "Split call node");
            }
            this.currentCallTarget = splitTarget;
            OptimizedCallTarget.runtime().getListener().onCompilationSplit(this);
        });
    }

    @Override
    public boolean cloneCallTarget() {
        TruffleSplittingStrategy.forceSplitting(this);
        return true;
    }
}

