/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.EnterprisePolyglotImpl;
import com.oracle.truffle.polyglot.enterprise.GuestPolyglotIsolateServices;
import com.oracle.truffle.polyglot.enterprise.GuestSourceCache;
import com.oracle.truffle.polyglot.enterprise.HSContext;
import com.oracle.truffle.polyglot.enterprise.PolyglotHostServices;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateGuestFeatureEnabled;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.HSObject;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNI;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIMethodScope;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIUtil;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.JNIClassCache;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeObjectHandles;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.Isolate;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.IsolateThread;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.function.CEntryPoint;

public final class PolyglotIsolate {
    static volatile Lazy lazy;
    private static final PriorityBlockingQueue<TearDownAction> tearDownHooks;

    private PolyglotIsolate() {
    }

    @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_EnterprisePolyglotImpl_getIsolateId", builtin=CEntryPoint.Builtin.GET_ISOLATE, include=PolyglotIsolateGuestFeatureEnabled.class)
    static native Isolate getIsolateId(JNI.JNIEnv var0, JNI.JClass var1, IsolateThread var2);

    @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_EnterprisePolyglotImpl_attachIsolate", builtin=CEntryPoint.Builtin.ATTACH_THREAD, include=PolyglotIsolateGuestFeatureEnabled.class)
    static native IsolateThread attachIsolate(JNI.JNIEnv var0, JNI.JClass var1, Isolate var2);

    @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_EnterprisePolyglotImpl_detachIsolate", builtin=CEntryPoint.Builtin.DETACH_THREAD, include=PolyglotIsolateGuestFeatureEnabled.class)
    static native int detachIsolate(JNI.JNIEnv var0, JNI.JClass var1, IsolateThread var2);

    @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_EnterprisePolyglotImpl_initializeIsolate", include=PolyglotIsolateGuestFeatureEnabled.class)
    static long initializeIsolate(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2) {
        JNIMethodScope jNIMethodScope = new JNIMethodScope("PolyglotIsolate::initializeIsolate", jNIEnv);
        try {
            long l3 = NativeObjectHandles.create(new GuestPolyglotIsolateServices(EnterprisePolyglotImpl.instance));
            jNIMethodScope.close();
            return l3;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jNIMethodScope.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                return 0L;
            }
        }
    }

    static long getHostStackOverflowLimit() {
        return PolyglotIsolate.lazy.hostStackOveflowLimit.get();
    }

    static void registerTearDownHook(int n2, TearDownHook tearDownHook) {
        Objects.requireNonNull(tearDownHook, "TearDownHook must be non null.");
        tearDownHooks.offer(new TearDownAction(n2, tearDownHook));
    }

    static void tearDown() {
        TearDownAction tearDownAction = tearDownHooks.poll();
        while (tearDownAction != null) {
            tearDownAction.perform(JNIMethodScope.env());
            tearDownAction = tearDownHooks.poll();
        }
        PolyglotIsolate.lazy.disposed = true;
    }

    static void registerEngine(Object object, long l2) {
        PolyglotIsolate.lazy.engineHandleByEngineReceiver.put(object, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void patchEngine(Object object, Object object2) {
        Map<Object, Long> map = PolyglotIsolate.lazy.engineHandleByEngineReceiver;
        synchronized (map) {
            Long l2 = PolyglotIsolate.lazy.engineHandleByEngineReceiver.remove(object);
            PolyglotIsolate.lazy.engineHandleByEngineReceiver.put(object2, l2);
        }
    }

    static void registerContext(JNI.JNIEnv jNIEnv, Object object, long l2, long l3, JNI.JObject jObject) {
        Lazy lazy = PolyglotIsolate.lazy;
        PolyglotIsolate.cleanUpClosedContexts(jNIEnv, lazy);
        lazy.contextHandleByContextReceiver.put(object, l2);
        lazy.contextByHandle.put(l2, new HSContext(jNIEnv, l2, object, jObject, l3));
    }

    static Object getSource(long l2) {
        return PolyglotIsolate.lazy.sourceCache.unhand(l2);
    }

    static HSContext getHSContextByHandle(long l2) {
        return PolyglotIsolate.lazy.contextByHandle.get(l2);
    }

    private static void cleanUpClosedContexts(JNI.JNIEnv jNIEnv, Lazy lazy) {
        Iterator<Long> iterator = lazy.contextsToClean.iterator();
        while (iterator.hasNext()) {
            PolyglotIsolate.cleanUpHSContext(jNIEnv, lazy, iterator.next());
            iterator.remove();
        }
        tearDownHooks.removeIf(tearDownAction -> tearDownAction.get() == null);
    }

    static void cleanUpHSContext(JNI.JNIEnv jNIEnv, Lazy lazy, long l2) {
        HSContext hSContext = lazy.contextByHandle.remove(l2);
        if (hSContext != null) {
            lazy.contextHandleByContextReceiver.remove(hSContext.getPolyglotContextReceiverReference());
            hSContext.dispose(jNIEnv);
        }
    }

    @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_EnterprisePolyglotImpl_releaseHandle", include=PolyglotIsolateGuestFeatureEnabled.class)
    static long releaseHandle(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
        try {
            NativeObjectHandles.remove(l3);
            return 0L;
        }
        catch (Throwable throwable) {
            return -1L;
        }
    }

    static {
        tearDownHooks = new PriorityBlockingQueue(7, Comparator.reverseOrder());
    }

    static final class Lazy
    implements TearDownHook {
        final JNI.JavaVM javaVM;
        final GuestSourceCache sourceCache;
        final PolyglotHostServices polyglotHostServices;
        final Map<Object, Long> contextHandleByContextReceiver;
        final Map<Object, Long> engineHandleByEngineReceiver;
        final Map<Long, HSContext> contextByHandle;
        final Set<Long> contextsToClean;
        final ThreadLocal<Long> hostStackOveflowLimit;
        volatile boolean disposed;

        Lazy(JNI.JNIEnv jNIEnv, PolyglotHostServices polyglotHostServices) {
            this.javaVM = JNIUtil.GetJavaVM(jNIEnv);
            this.sourceCache = new GuestSourceCache();
            this.polyglotHostServices = polyglotHostServices;
            this.contextHandleByContextReceiver = Collections.synchronizedMap(new WeakHashMap());
            this.engineHandleByEngineReceiver = Collections.synchronizedMap(new WeakHashMap());
            this.contextByHandle = new ConcurrentHashMap<Long, HSContext>();
            this.contextsToClean = Collections.newSetFromMap(new ConcurrentHashMap());
            this.hostStackOveflowLimit = ThreadLocal.withInitial(() -> polyglotHostServices.retrieveHostStackOverflowLimit());
            PolyglotIsolate.registerTearDownHook(Integer.MIN_VALUE, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object findEngineByHandle(long l2) {
            Map<Object, Long> map = this.engineHandleByEngineReceiver;
            synchronized (map) {
                for (Map.Entry<Object, Long> entry : this.engineHandleByEngineReceiver.entrySet()) {
                    if (entry.getValue() != l2) continue;
                    return entry.getKey();
                }
            }
            return null;
        }

        Object findContextByHandle(long l2) {
            HSContext hSContext = this.contextByHandle.get(l2);
            return hSContext != null ? hSContext.getPolyglotContextReceiverReference() : null;
        }

        @Override
        public void tearDown(JNI.JNIEnv jNIEnv) {
            HSObject.cleanHandles(jNIEnv);
            JNIClassCache.dispose(jNIEnv);
        }
    }

    private static final class TearDownAction
    extends WeakReference<TearDownHook>
    implements Comparable<TearDownAction> {
        private final int priority;

        TearDownAction(int n2, TearDownHook tearDownHook) {
            super(tearDownHook);
            this.priority = n2;
        }

        public void perform(JNI.JNIEnv jNIEnv) {
            TearDownHook tearDownHook = (TearDownHook)this.get();
            if (tearDownHook != null) {
                tearDownHook.tearDown(jNIEnv);
            }
        }

        @Override
        public int compareTo(TearDownAction tearDownAction) {
            return Integer.compare(this.priority, tearDownAction.priority);
        }
    }

    @FunctionalInterface
    static interface TearDownHook {
        public void tearDown(JNI.JNIEnv var1);
    }
}

