/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.EnterpriseEngineAccessor;
import com.oracle.truffle.polyglot.enterprise.EnterprisePolyglotImpl;
import com.oracle.truffle.polyglot.enterprise.NativeContext;
import com.oracle.truffle.polyglot.enterprise.NativeIsolateSourceCache;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeIsolate;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeIsolateThread;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.impl.AbstractPolyglotImpl;

abstract class NativeContextDispatch
extends AbstractPolyglotImpl.AbstractContextDispatch {
    private final EnterprisePolyglotImpl impl;
    private final AbstractPolyglotImpl.APIAccess apiAccess;
    private final ThreadLocal<ExplicitlyEnteredIsolate> explicitIsolateStack;

    NativeContextDispatch(EnterprisePolyglotImpl enterprisePolyglotImpl) {
        super(enterprisePolyglotImpl);
        this.impl = enterprisePolyglotImpl;
        this.apiAccess = enterprisePolyglotImpl.getAPIAccess();
        this.explicitIsolateStack = new ThreadLocal();
    }

    @Override
    public final void setAPI(Object object, Object object2) {
    }

    @Override
    public final Object asValue(Object object, Object object2) {
        return this.apiAccess.contextAsValue(((NativeContext)object).getLocalContext(), object2);
    }

    @Override
    public final Object eval(Object object, String string, Object object2) {
        return this.parseEval(object, string, object2, true);
    }

    @Override
    public final Object parse(Object object, String string, Object object2) {
        return this.parseEval(object, string, object2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object parseEval(Object object, String string, Object object2, boolean bl) {
        NativeContext nativeContext = (NativeContext)object;
        Object object3 = nativeContext.getLocalContext();
        Object object4 = this.enterIfNeeded(object3);
        try {
            Object object5;
            long l2 = nativeContext.getSourceCache().translate(object2);
            try {
                object5 = nativeContext.getPolyglotIsolateServices().parseEval(nativeContext, string, l2, bl);
            }
            catch (Throwable throwable) {
                if (!NativeIsolateSourceCache.isSourceRemotelyCacheable(object2, this.apiAccess)) {
                    nativeContext.getSourceCache().release(l2);
                }
                throw throwable;
            }
            if (!NativeIsolateSourceCache.isSourceRemotelyCacheable(object2, this.apiAccess)) {
                nativeContext.getSourceCache().release(l2);
            }
            return object5;
        }
        finally {
            this.leaveIfNeeded(object3, object4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean initializeLanguage(Object object, String string) {
        Object object2 = ((NativeContext)object).getLocalContext();
        Object object3 = this.enterIfNeeded(object2);
        try {
            boolean bl = this.initializeLanguageImpl(object, string);
            return bl;
        }
        finally {
            this.leaveIfNeeded(object2, object3);
        }
    }

    abstract boolean initializeLanguageImpl(Object var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close(Object object, boolean bl) {
        NativeContext nativeContext = (NativeContext)object;
        NativeIsolate nativeIsolate = nativeContext.getIsolate();
        boolean bl2 = this.impl.requireContextRegistered(nativeContext);
        if (bl2) {
            boolean bl3 = false;
            try {
                NativeIsolateThread nativeIsolateThread = nativeIsolate.tryEnter();
                if (nativeIsolateThread != null) {
                    try {
                        this.closeImpl(object, bl);
                        bl3 = true;
                    }
                    finally {
                        nativeIsolateThread.leave();
                        ExplicitlyEnteredIsolate explicitlyEnteredIsolate = this.explicitIsolateStack.get();
                        if (explicitlyEnteredIsolate != null && explicitlyEnteredIsolate.jniContext == nativeContext && !EnterpriseEngineAccessor.ENGINE.isContextEntered(this.apiAccess.getContextReceiver(nativeContext.getLocalContext()))) {
                            this.clearExplicitContextStack(nativeContext);
                        }
                    }
                } else {
                    this.apiAccess.contextClose(nativeContext.getLocalContext(), bl);
                }
                this.impl.releaseContextRegisteredRequirement(nativeContext, !nativeIsolate.isActive() && bl3);
            }
            catch (Throwable throwable) {
                this.impl.releaseContextRegisteredRequirement(nativeContext, !nativeIsolate.isActive() && bl3);
                throw throwable;
            }
        } else {
            this.apiAccess.contextClose(nativeContext.getLocalContext(), bl);
        }
    }

    private void clearExplicitContextStack(NativeContext nativeContext) {
        ExplicitlyEnteredIsolate explicitlyEnteredIsolate = this.explicitIsolateStack.get();
        while (explicitlyEnteredIsolate != null && explicitlyEnteredIsolate.jniContext == nativeContext) {
            explicitlyEnteredIsolate.nativeIsolateThread.leave();
            explicitlyEnteredIsolate = explicitlyEnteredIsolate.previous;
        }
        this.explicitIsolateStack.set(explicitlyEnteredIsolate);
    }

    abstract void closeImpl(Object var1, boolean var2);

    @Override
    public final void explicitEnter(Object object) {
        NativeContext nativeContext = (NativeContext)object;
        this.apiAccess.contextEnter(nativeContext.getLocalContext());
        try {
            NativeIsolateThread nativeIsolateThread = nativeContext.getIsolate().enter();
            this.explicitIsolateStack.set(new ExplicitlyEnteredIsolate(nativeContext, nativeIsolateThread, this.explicitIsolateStack.get()));
            this.explicitEnterImpl(object);
        }
        catch (Throwable throwable) {
            this.apiAccess.contextLeave(nativeContext.getLocalContext());
            throw throwable;
        }
    }

    abstract void explicitEnterImpl(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void explicitLeave(Object object) {
        NativeContext nativeContext = (NativeContext)object;
        try {
            if (nativeContext.getIsolate().isActive()) {
                this.explicitLeaveImpl(object);
                ExplicitlyEnteredIsolate explicitlyEnteredIsolate = this.explicitIsolateStack.get();
                this.explicitIsolateStack.set(explicitlyEnteredIsolate.previous);
                explicitlyEnteredIsolate.nativeIsolateThread.leave();
            }
        }
        finally {
            this.apiAccess.contextLeave(nativeContext.getLocalContext());
        }
    }

    abstract void explicitLeaveImpl(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object getBindings(Object object, String string) {
        Object object2 = ((NativeContext)object).getLocalContext();
        Object object3 = this.enterIfNeeded(object2);
        try {
            Object object4 = this.getBindingsImpl(object, string);
            return object4;
        }
        finally {
            this.leaveIfNeeded(object2, object3);
        }
    }

    abstract Object getBindingsImpl(Object var1, String var2);

    @Override
    public abstract Object getPolyglotBindings(Object var1);

    private Object enterIfNeeded(Object object) {
        Object object2 = this.apiAccess.getContextReceiver(object);
        return EnterpriseEngineAccessor.ENGINE.enterIfNeeded(object2);
    }

    private void leaveIfNeeded(Object object, Object object2) {
        Object object3 = this.apiAccess.getContextReceiver(object);
        EnterpriseEngineAccessor.ENGINE.leaveIfNeeded(object3, object2);
    }

    static AbstractPolyglotImpl.AbstractContextDispatch resolveNativeDelegate(Object object) {
        return EnterprisePolyglotImpl.instance.getAPIAccess().getContextDispatch(object);
    }

    static Object resolveReceiver(Object object) {
        return EnterprisePolyglotImpl.instance.getAPIAccess().getContextReceiver(object);
    }

    private static final class ExplicitlyEnteredIsolate {
        final NativeContext jniContext;
        final NativeIsolateThread nativeIsolateThread;
        final ExplicitlyEnteredIsolate previous;

        ExplicitlyEnteredIsolate(NativeContext nativeContext, NativeIsolateThread nativeIsolateThread, ExplicitlyEnteredIsolate explicitlyEnteredIsolate) {
            this.jniContext = nativeContext;
            this.nativeIsolateThread = nativeIsolateThread;
            this.previous = explicitlyEnteredIsolate;
        }
    }
}

