/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.wasm;

import com.oracle.truffle.api.ExactMath;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.wasm.ToWebAssemblyIndexOrSizeNodeGen;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;

public abstract class ToWebAssemblyIndexOrSizeNode
extends JavaScriptBaseNode {
    private final String errorMessagePrefix;
    private final BranchProfile errorBranch;
    @Node.Child
    JSToNumberNode toNumberNode;

    protected ToWebAssemblyIndexOrSizeNode(String errorMessagePrefix) {
        this.errorMessagePrefix = errorMessagePrefix;
        this.errorBranch = BranchProfile.create();
        this.toNumberNode = JSToNumberNode.create();
    }

    public static ToWebAssemblyIndexOrSizeNode create(String errorMessagePrefix) {
        return ToWebAssemblyIndexOrSizeNodeGen.create(errorMessagePrefix);
    }

    public abstract int executeInt(Object var1);

    @Specialization
    protected int convertInt(int intValue) {
        if (intValue < 0) {
            this.errorBranch.enter();
            throw Errors.createTypeErrorFormat("%s must be non-negative", this, this.errorMessagePrefix);
        }
        return intValue;
    }

    @Specialization(replaces={"convertInt"})
    protected int convert(Object value) {
        Number valueNumber = this.toNumberNode.executeNumber(value);
        double valueDouble = JSRuntime.doubleValue(valueNumber);
        if (!Double.isFinite(valueDouble)) {
            this.errorBranch.enter();
            throw Errors.createTypeErrorFormat("%s must be convertible to a valid number", this, this.errorMessagePrefix);
        }
        if ((valueDouble = ExactMath.truncate(valueDouble)) < 0.0) {
            this.errorBranch.enter();
            throw Errors.createTypeErrorFormat("%s must be non-negative", this, this.errorMessagePrefix);
        }
        if (valueDouble > 4.294967295E9) {
            this.errorBranch.enter();
            throw Errors.createTypeErrorFormat("%s must be in the unsigned long range", this, this.errorMessagePrefix);
        }
        if (valueDouble > 2.147483647E9) {
            this.errorBranch.enter();
            throw Errors.createRangeErrorFormat("%s must be in the int range", this, this.errorMessagePrefix);
        }
        return (int)valueDouble;
    }
}

