/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarObjectNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class TemporalUnbalanceDateDurationRelativeNode
extends JavaScriptBaseNode {
    protected TemporalUnbalanceDateDurationRelativeNode() {
    }

    public abstract double execute(double var1, double var3, double var5, double var7, JSTemporalPlainDateObject var9, CalendarMethodsRecord var10);

    @Specialization
    protected double unbalanceDurationRelative(double years, double months, double weeks, double days, JSTemporalPlainDateObject plainRelativeTo, CalendarMethodsRecord calendarRec, @Cached ToTemporalCalendarObjectNode toCalendarObjectNode, @Cached(value="createCall()") JSFunctionCallNode callDateAddNode, @Cached InlinedBranchProfile errorBranch) {
        assert (plainRelativeTo != null && calendarRec != null && calendarRec.dateAdd() != null);
        if (years == 0.0 && months == 0.0 && weeks == 0.0) {
            return days;
        }
        JSContext ctx = this.getJSContext();
        JSRealm realm = this.getRealm();
        JSTemporalDurationObject yearsMonthsWeeksDuration = JSTemporalDuration.createTemporalDuration(ctx, realm, years, months, weeks, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
        JSTemporalPlainDateObject later = TemporalUtil.calendarDateAdd(calendarRec, plainRelativeTo, yearsMonthsWeeksDuration, Undefined.instance, toCalendarObjectNode, callDateAddNode);
        double yearsMonthsWeeksInDays = TemporalUtil.daysUntil(plainRelativeTo, later);
        return days + yearsMonthsWeeksInDays;
    }
}

