/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.Truncatable;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.binary.JSBinaryNode;
import com.oracle.truffle.js.nodes.binary.JSBitwiseOrConstantNode;
import com.oracle.truffle.js.nodes.binary.JSBitwiseOrNodeGen;
import com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Strings;
import java.util.Set;

@NodeInfo(shortName="|")
public abstract class JSBitwiseOrNode
extends JSBinaryNode {
    protected JSBitwiseOrNode(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    public static JavaScriptNode create(JavaScriptNode left, JavaScriptNode right) {
        Truncatable.truncate(left);
        if (right instanceof JSConstantNode.JSConstantIntegerNode) {
            int rightValue = ((JSConstantNode.JSConstantIntegerNode)right).executeInt(null);
            if (rightValue == 0) {
                return JSToInt32Node.create(left, true);
            }
            return JSBitwiseOrConstantNode.create(left, rightValue);
        }
        Truncatable.truncate(right);
        return JSBitwiseOrNodeGen.create(left, right);
    }

    public abstract Object executeObject(Object var1, Object var2);

    @Specialization
    protected int doInteger(int a2, int b2) {
        return a2 | b2;
    }

    @Specialization
    protected int doSafeIntegerInt(SafeInteger a2, int b2) {
        return this.doInteger(a2.intValue(), b2);
    }

    @Specialization
    protected int doIntSafeInteger(int a2, SafeInteger b2) {
        return this.doInteger(a2, b2.intValue());
    }

    @Specialization
    protected int doSafeInteger(SafeInteger a2, SafeInteger b2) {
        return this.doInteger(a2.intValue(), b2.intValue());
    }

    @Specialization
    protected int doDouble(double a2, double b2, @Cached JSToInt32Node leftInt32, @Cached JSToInt32Node rightInt32) {
        return this.doInteger(leftInt32.executeInt(a2), rightInt32.executeInt(b2));
    }

    @Specialization
    protected BigInt doBigInt(BigInt a2, BigInt b2) {
        return a2.or(b2);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"hasOverloadedOperators(a) || hasOverloadedOperators(b)"})
    protected Object doOverloaded(Object a2, Object b2, @Cached(value="createNumeric(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode) {
        return overloadedOperatorNode.execute(a2, b2);
    }

    protected TruffleString getOverloadedOperatorName() {
        return Strings.SYMBOL_PIPE;
    }

    @Specialization(guards={"!hasOverloadedOperators(a)", "!hasOverloadedOperators(b)"}, replaces={"doInteger", "doIntSafeInteger", "doSafeIntegerInt", "doSafeInteger", "doDouble", "doBigInt"})
    protected static Object doGeneric(Object a2, Object b2, @Bind(value="this") Node node, @Cached JSToNumericNode leftNumeric, @Cached JSToNumericNode rightNumeric, @Cached(value="createInner()") JSBitwiseOrNode or, @Cached InlinedBranchProfile mixedNumericTypes) {
        Object left = leftNumeric.execute(a2);
        Object right = rightNumeric.execute(b2);
        JSBitwiseOrNode.ensureBothSameNumericType(left, right, node, mixedNumericTypes);
        return or.executeObject(left, right);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSBitwiseOrNodeGen.create(JSBitwiseOrNode.cloneUninitialized(this.getLeft(), materializedTags), JSBitwiseOrNode.cloneUninitialized(this.getRight(), materializedTags));
    }

    public static final JSBitwiseOrNode createInner() {
        return JSBitwiseOrNodeGen.create(null, null);
    }
}

