/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;
import java.util.Comparator;
import java.util.Objects;

@ImportStatic(value={JSConfig.class})
public abstract class JSTypedArraySortNode
extends JavaScriptBaseNode {
    static final int CACHE_LIMIT = 6;

    protected JSTypedArraySortNode() {
    }

    public abstract void execute(JSTypedArrayObject var1, JSTypedArrayObject var2, int var3, Comparator<Object> var4);

    @Specialization(guards={"cachedFromType.isInstance(fromType)", "cachedToType.isInstance(toType)", "cachedComparatorIsNull == comparatorIsNull"}, limit="CACHE_LIMIT")
    protected final void doCached(JSTypedArrayObject fromArray, JSTypedArrayObject toArray, int length, Comparator<Object> comparator, @Bind(value="fromArray.getArrayType()") TypedArray fromType, @Bind(value="toArray.getArrayType()") TypedArray toType, @Bind(value="comparator == null") boolean comparatorIsNull, @Cached(value="fromType") TypedArray cachedFromType, @Cached(value="toType") TypedArray cachedToType, @Cached(value="comparatorIsNull") boolean cachedComparatorIsNull, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary interop) {
        this.doUncached(fromArray, toArray, length, comparator, cachedFromType, cachedToType, cachedComparatorIsNull, interop);
    }

    @Specialization(replaces={"doCached"})
    protected final void doUncached(JSTypedArrayObject fromArray, JSTypedArrayObject toArray, int length, Comparator<Object> comparator, @Bind(value="fromArray.getArrayType()") TypedArray fromType, @Bind(value="toArray.getArrayType()") TypedArray toType, @Bind(value="comparator == null") boolean comparatorIsNull, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary interop) {
        Comparator<Object> useComparator;
        assert (fromType.getElementType() == toType.getElementType() && fromArray.getArrayType() == fromType && toArray.getArrayType() == toType);
        assert (fromArray.getLength() == length && toArray.getLength() == length);
        Comparator<Object> comparator2 = useComparator = comparatorIsNull ? null : Objects.requireNonNull(comparator);
        if (fromType instanceof TypedArray.TypedIntArray) {
            this.sortIntArray(fromArray, toArray, length, useComparator, (TypedArray.TypedIntArray)fromType, (TypedArray.TypedIntArray)toType, interop);
        } else if (fromType instanceof TypedArray.TypedFloatArray) {
            this.sortFloatArray(fromArray, toArray, length, useComparator, (TypedArray.TypedFloatArray)fromType, (TypedArray.TypedFloatArray)toType, interop);
        } else if (fromType instanceof TypedArray.TypedBigIntArray) {
            this.sortBigInt64Array(fromArray, toArray, length, useComparator, (TypedArray.TypedBigIntArray)fromType, (TypedArray.TypedBigIntArray)toType, interop);
        } else {
            throw Errors.shouldNotReachHereUnexpectedValue(fromType);
        }
        LoopNode.reportLoopCount(this, length);
    }

    private void sortIntArray(JSTypedArrayObject fromArray, JSTypedArrayObject toArray, int length, Comparator<Object> comparator, TypedArray.TypedIntArray fromType, TypedArray.TypedIntArray toType, InteropLibrary interop) {
        if (comparator == null) {
            if (fromType instanceof TypedArray.AbstractUint32Array) {
                int i2;
                long[] arr = new long[length];
                for (i2 = 0; i2 < length; ++i2) {
                    arr[i2] = Integer.toUnsignedLong(fromType.getInt(fromArray, i2, interop));
                }
                Boundaries.arraySort(arr);
                for (i2 = 0; i2 < length; ++i2) {
                    toType.setInt(toArray, i2, (int)arr[i2], interop);
                }
            } else {
                int i3;
                int[] arr = new int[length];
                for (i3 = 0; i3 < length; ++i3) {
                    arr[i3] = fromType.getInt(fromArray, i3, interop);
                }
                Boundaries.arraySort(arr);
                for (i3 = 0; i3 < length; ++i3) {
                    toType.setInt(toArray, i3, arr[i3], interop);
                }
            }
        } else {
            int i4;
            boolean zeroExtend = fromType instanceof TypedArray.AbstractUint32Array;
            Object[] arr = new Object[length];
            for (i4 = 0; i4 < length; ++i4) {
                int intValue = fromType.getInt(fromArray, i4, interop);
                arr[i4] = zeroExtend ? SafeInteger.valueOf(Integer.toUnsignedLong(intValue)) : Integer.valueOf(intValue);
            }
            Boundaries.arraySort(arr, comparator);
            if (this.isTypedArrayOutOfBounds(toArray)) {
                return;
            }
            for (i4 = 0; i4 < length; ++i4) {
                Object value = arr[i4];
                int intValue = zeroExtend ? ((SafeInteger)value).intValue() : ((Integer)value).intValue();
                toType.setInt(toArray, i4, intValue, interop);
            }
        }
    }

    private void sortFloatArray(JSTypedArrayObject fromArray, JSTypedArrayObject toArray, int length, Comparator<Object> comparator, TypedArray.TypedFloatArray fromType, TypedArray.TypedFloatArray toType, InteropLibrary interop) {
        if (comparator == null) {
            int i2;
            double[] arr = new double[length];
            for (i2 = 0; i2 < length; ++i2) {
                arr[i2] = fromType.getDouble(fromArray, i2, interop);
            }
            Boundaries.arraySort(arr);
            for (i2 = 0; i2 < length; ++i2) {
                toType.setDouble(toArray, i2, arr[i2], interop);
            }
        } else {
            int i3;
            Double[] arr = new Double[length];
            for (i3 = 0; i3 < length; ++i3) {
                arr[i3] = fromType.getDouble(fromArray, i3, interop);
            }
            Boundaries.arraySort(arr, comparator);
            if (this.isTypedArrayOutOfBounds(toArray)) {
                return;
            }
            for (i3 = 0; i3 < length; ++i3) {
                toType.setDouble(toArray, i3, arr[i3], interop);
            }
        }
    }

    private void sortBigInt64Array(JSTypedArrayObject fromArray, JSTypedArrayObject toArray, int length, Comparator<Object> comparator, TypedArray.TypedBigIntArray fromType, TypedArray.TypedBigIntArray toType, InteropLibrary interop) {
        if (comparator == null && (fromType instanceof TypedArray.BigInt64Array || fromType instanceof TypedArray.DirectBigInt64Array || fromType instanceof TypedArray.InteropBigInt64Array)) {
            int i2;
            long[] arr = new long[length];
            for (i2 = 0; i2 < length; ++i2) {
                arr[i2] = fromType.getLong(fromArray, i2, interop);
            }
            Boundaries.arraySort(arr);
            for (i2 = 0; i2 < length; ++i2) {
                toType.setLong(toArray, i2, arr[i2], interop);
            }
        } else {
            int i3;
            BigInt[] arr = new BigInt[length];
            for (i3 = 0; i3 < length; ++i3) {
                arr[i3] = fromType.getBigInt(fromArray, i3, interop);
            }
            Boundaries.arraySort(arr, comparator);
            if (this.isTypedArrayOutOfBounds(toArray)) {
                return;
            }
            for (i3 = 0; i3 < length; ++i3) {
                toType.setBigInt(toArray, i3, arr[i3], interop);
            }
        }
    }

    private boolean isTypedArrayOutOfBounds(JSTypedArrayObject toArray) {
        return JSArrayBufferView.isOutOfBounds(toArray, this.getJSContext());
    }
}

