/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.builtins.math.MathOperation;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;

public abstract class CeilNode
extends MathOperation {
    public CeilNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    @Specialization
    protected static int ceilInt(int a2) {
        return a2;
    }

    @Specialization
    protected static SafeInteger ceilSafeInt(SafeInteger a2) {
        return a2;
    }

    @Specialization
    protected final Object ceilDouble(double d2, @Cached @Cached.Shared InlinedConditionProfile isZero, @Cached @Cached.Shared InlinedConditionProfile requiresNegativeZero, @Cached @Cached.Shared InlinedConditionProfile fitsInt, @Cached @Cached.Shared InlinedConditionProfile fitsSafeLong) {
        if (isZero.profile(this, d2 == 0.0)) {
            return d2;
        }
        if (fitsInt.profile(this, d2 >= -2.147483648E9 && d2 <= 2.147483647E9)) {
            int i2 = (int)d2;
            int result = d2 > (double)i2 ? i2 + 1 : i2;
            if (requiresNegativeZero.profile(this, result == 0 && d2 < 0.0)) {
                return -0.0;
            }
            return result;
        }
        if (fitsSafeLong.profile(this, JSRuntime.isSafeInteger(d2))) {
            long i3 = (long)d2;
            long result = d2 > (double)i3 ? i3 + 1L : i3;
            if (requiresNegativeZero.profile(this, result == 0L && d2 < 0.0)) {
                return -0.0;
            }
            return SafeInteger.valueOf(result);
        }
        return Math.ceil(d2);
    }

    @Specialization(replaces={"ceilDouble"})
    protected final Object ceilToDouble(Object a2, @Cached @Cached.Shared InlinedConditionProfile isZero, @Cached @Cached.Shared InlinedConditionProfile requiresNegativeZero, @Cached @Cached.Shared InlinedConditionProfile fitsInt, @Cached @Cached.Shared InlinedConditionProfile fitsSafeLong) {
        double d2 = this.toDouble(a2);
        return this.ceilDouble(d2, isZero, requiresNegativeZero, fitsInt, fitsSafeLong);
    }
}

