/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.item.IAspectVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectRead;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectVariable;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.api.part.read.IPartStateReader;
import org.cyclops.integrateddynamics.api.part.read.IPartTypeReader;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.api.part.write.IPartTypeWriter;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.evaluate.variable.Variable;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.item.AspectVariableFacade;
import org.cyclops.integrateddynamics.core.logicprogrammer.OperatorLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamics.item.ItemVariable;
import org.cyclops.integrateddynamics.part.PartTypePanelDisplay;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public class GameTestHelpersIntegratedDynamics {
    public static void assertValueEqual(IValue value1, IValue value2) {
        if (!Objects.equals(value1, value2)) {
            throw new GameTestAssertException(String.format("Value %s does not equal value %s", value1, value2));
        }
    }

    public static void assertValueEqual(@Nullable IVariable value1, IValue value2) {
        if (value1 == null) {
            throw new GameTestAssertException("Variable is null");
        }
        try {
            GameTestHelpersIntegratedDynamics.assertValueEqual(value1.getValue(), value2);
        }
        catch (EvaluationException e) {
            throw new GameTestAssertException(e.getMessage());
        }
    }

    public static ItemStack createVariableForValue(Level level, IValueType valueType, IValue value) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_VARIABLE);
        return registry.writeVariableFacadeItem(true, itemStack, ValueTypes.REGISTRY, new ValueTypeLPElementBase.ValueTypeVariableFacadeFactory(valueType, value), level, null, ((Block)RegistryEntries.BLOCK_LOGIC_PROGRAMMER.get()).defaultBlockState());
    }

    public static ItemStack createVariableForOperator(Level level, IOperator operator, int[] variableIds) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_VARIABLE);
        return registry.writeVariableFacadeItem(true, itemStack, Operators.REGISTRY, new OperatorLPElement.OperatorVariableFacadeFactory(operator, variableIds), level, null, ((Block)RegistryEntries.BLOCK_LOGIC_PROGRAMMER.get()).defaultBlockState());
    }

    public static IVariableFacade getVariableFacade(Level level, ItemStack itemStack) {
        return ((ItemVariable)((Object)RegistryEntries.ITEM_VARIABLE.get())).getVariableFacade(ValueDeseralizationContext.of(level), itemStack);
    }

    public static ItemStack createVariableFromReader(Level level, PartPos partPos, IAspect aspect) {
        return GameTestHelpersIntegratedDynamics.createVariableFromReader(level, aspect, PartHelpers.getPart(partPos).getState());
    }

    public static ItemStack createVariableFromReader(Level level, final IAspect aspect, final IPartState partState) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_VARIABLE);
        return registry.writeVariableFacadeItem(true, itemStack, Aspects.REGISTRY, new IVariableFacadeHandlerRegistry.IVariableFacadeFactory<IAspectVariableFacade>(){

            @Override
            public IAspectVariableFacade create(boolean generateId) {
                return new AspectVariableFacade(generateId, partState.getId(), aspect);
            }

            @Override
            public IAspectVariableFacade create(int id) {
                return new AspectVariableFacade(id, partState.getId(), aspect);
            }
        }, level, null, null);
    }

    public static void placeVariableInWriter(Level level, PartPos partPos, IAspectWrite<?, ?> aspect, ItemStack variableAspect) {
        PartHelpers.PartStateHolder<?, ?> partStateHolder = PartHelpers.getPart(partPos);
        IPartTypeWriter part = (IPartTypeWriter)partStateHolder.getPart();
        IPartStateWriter state = (IPartStateWriter)partStateHolder.getState();
        int aspectIndex = -1;
        for (int i = 0; i < part.getWriteAspects().size(); ++i) {
            if (part.getWriteAspects().get(i) != aspect) continue;
            aspectIndex = i;
        }
        if (aspectIndex < 0) {
            throw new GameTestAssertException("Aspect " + String.valueOf(aspect) + " not found");
        }
        state.getInventory().setItem(aspectIndex, variableAspect);
        part.updateActivation(PartTarget.fromCenter(partPos), state, null);
    }

    public static Pair<PartTypePanelDisplay, PartTypePanelDisplay.State> placeVariableInDisplayPanel(Level level, PartPos partPos, ItemStack variableAspect) {
        PartHelpers.PartStateHolder<?, ?> partStateHolder = PartHelpers.getPart(partPos);
        PartTypePanelDisplay part = (PartTypePanelDisplay)partStateHolder.getPart();
        PartTypePanelDisplay.State state = (PartTypePanelDisplay.State)partStateHolder.getState();
        state.getInventory().setItem(0, variableAspect);
        return Pair.of((Object)part, (Object)state);
    }

    public static Supplier<IAspectVariable> testReadAspectSetup(BlockPos pos, GameTestHelper helper, IPartTypeReader<?, ?> partType, IAspectRead<?, ?> aspectRead) {
        helper.setBlock(pos, (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(pos), Direction.WEST, partType, new ItemStack((ItemLike)partType.getItem()));
        PartPos partPos = PartPos.of((Level)helper.getLevel(), helper.absolutePos(pos), Direction.WEST);
        PartHelpers.PartStateHolder<?, ?> partStateHolder = PartHelpers.getPart(partPos);
        IPartTypeReader partReader = (IPartTypeReader)partStateHolder.getPart();
        IPartStateReader partStateReader = (IPartStateReader)partStateHolder.getState();
        return () -> partReader.getVariable(PartTarget.fromCenter(partPos), partStateReader, aspectRead);
    }

    public static <V extends IValue> void testReadAspectThrows(BlockPos pos, GameTestHelper helper, IPartTypeReader<?, ?> partType, IAspectRead<V, ?> aspectRead) {
        Supplier<IAspectVariable> variableSupplier = GameTestHelpersIntegratedDynamics.testReadAspectSetup(pos, helper, partType, aspectRead);
        helper.succeedWhen(() -> {
            try {
                ((IAspectVariable)variableSupplier.get()).getValue();
                helper.assertTrue(false, "The aspect did not throw");
            }
            catch (EvaluationException e) {
                helper.assertTrue(true, "The aspect did successfully throw");
            }
        });
    }

    public static <V extends IValue> void testReadAspect(BlockPos pos, GameTestHelper helper, IPartTypeReader<?, ?> partType, IAspectRead<V, ?> aspectRead, V expectedValue) {
        Supplier<IAspectVariable> variableSupplier = GameTestHelpersIntegratedDynamics.testReadAspectSetup(pos, helper, partType, aspectRead);
        helper.succeedWhen(() -> GameTestHelpersIntegratedDynamics.assertValueEqual((IVariable)variableSupplier.get(), expectedValue));
    }

    public static <V extends IValue> void testReadAspectPredicate(BlockPos pos, GameTestHelper helper, IPartTypeReader<?, ?> partType, IAspectRead<V, ?> aspectRead, Predicate<V> asserter) {
        Supplier<IAspectVariable> variableSupplier = GameTestHelpersIntegratedDynamics.testReadAspectSetup(pos, helper, partType, aspectRead);
        helper.succeedWhen(() -> {
            try {
                helper.assertTrue(asserter.test(((IAspectVariable)variableSupplier.get()).getValue()), "Value was not asserted correctly");
            }
            catch (EvaluationException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static <V extends IValue> void testReadAspectOperator(BlockPos pos, GameTestHelper helper, IPartTypeReader<?, ?> partType, IAspectRead<V, ?> aspectRead, List<IValue> operatorInputs, IValue expectedOperatorOutput) {
        Supplier<IAspectVariable> variableSupplier = GameTestHelpersIntegratedDynamics.testReadAspectSetup(pos, helper, partType, aspectRead);
        helper.succeedWhen(() -> {
            try {
                Object operatorValue = ((IAspectVariable)variableSupplier.get()).getValue();
                if (!(operatorValue instanceof ValueTypeOperator.ValueOperator)) {
                    throw new GameTestAssertException("Return value is not an operator");
                }
                ValueTypeOperator.ValueOperator operator = (ValueTypeOperator.ValueOperator)operatorValue;
                IValue output = operator.getRawValue().evaluate((IVariable[])operatorInputs.stream().map(Variable::new).toArray(Variable[]::new));
                GameTestHelpersIntegratedDynamics.assertValueEqual(output, expectedOperatorOutput);
            }
            catch (EvaluationException e) {
                throw new GameTestAssertException(e.getMessage());
            }
        });
    }

    public static <V extends IValue> void testReadAspectOperatorPredicate(BlockPos pos, GameTestHelper helper, IPartTypeReader<?, ?> partType, IAspectRead<V, ?> aspectRead, List<IValue> operatorInputs, Predicate<IValue> asserter) {
        Supplier<IAspectVariable> variableSupplier = GameTestHelpersIntegratedDynamics.testReadAspectSetup(pos, helper, partType, aspectRead);
        helper.succeedWhen(() -> {
            try {
                Object operatorValue = ((IAspectVariable)variableSupplier.get()).getValue();
                if (!(operatorValue instanceof ValueTypeOperator.ValueOperator)) {
                    throw new GameTestAssertException("Return value is not an operator");
                }
                ValueTypeOperator.ValueOperator operator = (ValueTypeOperator.ValueOperator)operatorValue;
                IValue output = operator.getRawValue().evaluate((IVariable[])operatorInputs.stream().map(Variable::new).toArray(Variable[]::new));
                helper.assertTrue(asserter.test(output), "Value was not asserted correctly");
            }
            catch (EvaluationException e) {
                throw new GameTestAssertException(e.getMessage());
            }
        });
    }

    public static <V extends IValue> void testWriteAspectSetup(BlockPos pos, GameTestHelper helper, IPartTypeWriter<?, ?> partType, IAspectWrite<V, ?> aspectWrite, ItemStack variableAspect) {
        if (helper.getLevel().isEmptyBlock(helper.absolutePos(pos))) {
            helper.setBlock(pos, (Block)RegistryEntries.BLOCK_CABLE.value());
        }
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(pos), Direction.WEST, partType, new ItemStack((ItemLike)partType.getItem()));
        PartPos partPos = PartPos.of((Level)helper.getLevel(), helper.absolutePos(pos), Direction.WEST);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), partPos, aspectWrite, variableAspect);
    }

    public static <V extends IValue> void testWriteAspectSetup(BlockPos pos, GameTestHelper helper, IPartTypeWriter<?, ?> partType, IAspectWrite<V, ?> aspectWrite, V value) {
        GameTestHelpersIntegratedDynamics.testWriteAspectSetup(pos, helper, partType, aspectWrite, GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), value.getType(), value));
    }
}

