/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network.diagnostics;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;

public class NetworkDiagnosticsPartOverlayRenderer {
    private static final NetworkDiagnosticsPartOverlayRenderer _INSTANCE = new NetworkDiagnosticsPartOverlayRenderer();
    private final Set<PartPos> partPositions = Sets.newHashSet();

    private NetworkDiagnosticsPartOverlayRenderer() {
    }

    public static NetworkDiagnosticsPartOverlayRenderer getInstance() {
        return _INSTANCE;
    }

    public synchronized void addPos(PartPos pos) {
        this.partPositions.add(pos);
    }

    public synchronized void removePos(PartPos pos) {
        this.partPositions.remove(pos);
    }

    public synchronized void clearPositions() {
        this.partPositions.clear();
    }

    public synchronized boolean hasPartPos(PartPos pos) {
        return this.partPositions.contains(pos);
    }

    @SubscribeEvent
    public void onRender(RenderLevelStageEvent event) {
        if (!this.partPositions.isEmpty() && event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            LocalPlayer player = Minecraft.getInstance().player;
            Vec3 eyePos = event.getCamera().getPosition();
            double offsetX = eyePos.x;
            double offsetY = eyePos.y;
            double offsetZ = eyePos.z;
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.lineWidth((float)6.0f);
            RenderSystem.depthMask((boolean)false);
            ArrayList partList = Lists.newArrayList(this.partPositions);
            for (PartPos partPos : partList) {
                if (!partPos.getPos().getLevelKey().location().equals((Object)player.level().dimension().location()) || !(partPos.getPos().getBlockPos().distSqr((Vec3i)player.blockPosition()) < 10000.0)) continue;
                PartHelpers.PartStateHolder<?, ?> partStateHolder = PartHelpers.getPart(partPos);
                VoxelShape shape = partStateHolder != null ? partStateHolder.getPart().getPartRenderPosition().getBoundingBox(partPos.getSide(), CollisionContext.empty()) : Shapes.BLOCK;
                AABB bb = shape.bounds().move(partPos.getPos().getBlockPos()).move(-offsetX, -offsetY, -offsetZ).inflate(0.05, 0.05, 0.05).inflate(-0.05, -0.05, -0.05);
                LevelRenderer.renderLineBox((PoseStack)event.getPoseStack(), (VertexConsumer)Minecraft.getInstance().renderBuffers().outlineBufferSource().getBuffer(RenderType.lines()), (AABB)bb, (float)1.0f, (float)0.2f, (float)0.1f, (float)0.8f);
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
        }
    }
}

