/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.cyclops.integrateddynamics.api.client.model.IVariableModelBaked;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.item.IValueTypeVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.core.client.model.VariableModelProviders;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.Variable;
import org.cyclops.integrateddynamics.core.item.VariableFacadeBase;

public class ValueTypeVariableFacade<V extends IValue>
extends VariableFacadeBase
implements IValueTypeVariableFacade<V> {
    private final IValueType<V> valueType;
    private final V value;
    private IVariable<V> variable = null;

    public ValueTypeVariableFacade(boolean generateId, IValueType<V> valueType, V value) {
        super(generateId);
        this.valueType = valueType;
        this.value = value;
    }

    public ValueTypeVariableFacade(int id, IValueType<V> valueType, V value) {
        super(id);
        this.valueType = valueType;
        this.value = value;
    }

    public ValueTypeVariableFacade(boolean generateId, IValueType<V> valueType, ValueDeseralizationContext valueDeseralizationContext, Tag value) {
        super(generateId);
        this.valueType = valueType;
        this.value = ValueHelpers.deserializeRaw(valueDeseralizationContext, valueType, value);
    }

    public ValueTypeVariableFacade(int id, IValueType<V> valueType, ValueDeseralizationContext valueDeseralizationContext, Tag value) {
        super(id);
        this.valueType = valueType;
        this.value = ValueHelpers.deserializeRaw(valueDeseralizationContext, valueType, value);
    }

    @Override
    public IVariable<V> getVariable(INetwork network, IPartNetwork partNetwork) {
        if (this.isValid()) {
            if (this.variable == null) {
                this.variable = new Variable<V>(this.getValueType(), this.getValue());
            }
            return this.variable;
        }
        return null;
    }

    @Override
    public boolean isValid() {
        return this.getValueType() != null && this.getValue() != null;
    }

    @Override
    public void validate(INetwork network, IPartNetwork partNetwork, IVariableFacade.IValidator validator, IValueType containingValueType) {
        if (!this.isValid()) {
            validator.addError(Component.translatable((String)"variable.integrateddynamics.error.invalid_item"));
        } else if (!ValueHelpers.correspondsTo(this.getValueType(), containingValueType)) {
            validator.addError(Component.translatable((String)"aspect.integrateddynamics.error.invalid_type", (Object[])new Object[]{Component.translatable((String)containingValueType.getTranslationKey()), Component.translatable((String)this.getValueType().getTranslationKey())}));
        }
    }

    @Override
    public IValueType getOutputType() {
        return this.getValueType();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(List<Component> list, Item.TooltipContext context) {
        if (this.isValid()) {
            V value = this.getValue();
            this.getValueType().loadTooltip(list, false, value);
            list.add((Component)Component.translatable((String)"valuetype.integrateddynamics.tooltip.value", (Object[])new Object[]{this.getValueType().toCompactString(value)}));
        }
        super.appendHoverText(list, context);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addModelOverlay(IVariableModelBaked variableModelBaked, List<BakedQuad> quads, RandomSource random, ModelData modelData) {
        BakedModel bakedModel;
        if (this.isValid() && (bakedModel = variableModelBaked.getSubModels(VariableModelProviders.VALUETYPE).getBakedModels().get(this.getValueType())) != null) {
            quads.addAll(bakedModel.getQuads(null, null, random, modelData, null));
        }
    }

    @Override
    @Nullable
    public BakedModel getVariableItemOverrideModel(BakedModel model, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity livingEntity) {
        if (this.isValid()) {
            return this.getValueType().getVariableItemOverrideModel(this.getValue(), model, stack, world, livingEntity);
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderISTER(ItemStack stack, ItemDisplayContext transformType, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (this.isValid()) {
            this.getValueType().renderISTER(this.getValue(), stack, transformType, matrixStack, buffer, combinedLight, combinedOverlay);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueTypeVariableFacade)) {
            return false;
        }
        ValueTypeVariableFacade other = (ValueTypeVariableFacade)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IValueType<V> this$valueType = this.getValueType();
        IValueType<V> other$valueType = other.getValueType();
        if (this$valueType == null ? other$valueType != null : !this$valueType.equals(other$valueType)) {
            return false;
        }
        V this$value = this.getValue();
        V other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        IVariable<V> this$variable = this.getVariable();
        IVariable<V> other$variable = other.getVariable();
        return !(this$variable == null ? other$variable != null : !this$variable.equals(other$variable));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ValueTypeVariableFacade;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        IValueType<V> $valueType = this.getValueType();
        result = result * 59 + ($valueType == null ? 43 : $valueType.hashCode());
        V $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        IVariable<V> $variable = this.getVariable();
        result = result * 59 + ($variable == null ? 43 : $variable.hashCode());
        return result;
    }

    @Override
    public IValueType<V> getValueType() {
        return this.valueType;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public IVariable<V> getVariable() {
        return this.variable;
    }

    public void setVariable(IVariable<V> variable) {
        this.variable = variable;
    }

    @Override
    public String toString() {
        return "ValueTypeVariableFacade(valueType=" + String.valueOf(this.getValueType()) + ", value=" + String.valueOf(this.getValue()) + ", variable=" + String.valueOf(this.getVariable()) + ")";
    }
}

