/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntry;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntryListener;

public class WidgetTextFieldDropdown<T>
extends WidgetTextFieldExtended {
    private Set<IDropdownEntry<T>> possibilities;
    private List<IDropdownEntry<T>> visiblePossibilities = Collections.emptyList();
    private int visiblePossibilitiesIndex = -1;
    private IDropdownEntry<T> selectedDropdownPossibility = null;
    private int dropdownSize = 5;
    private IDropdownEntryListener<T> dropdownEntryListener;
    private int enabledColor = 0xE0E0E0;
    private int disabledColor = 0x707070;

    public WidgetTextFieldDropdown(Font fontrenderer, int x, int y, int width, int height, Component narrationMessage, boolean background, Set<IDropdownEntry<T>> possibilities) {
        super(fontrenderer, x, y, width, height, narrationMessage, background);
        this.setPossibilities(Objects.requireNonNull(possibilities));
    }

    public WidgetTextFieldDropdown(Font fontrenderer, int x, int y, int width, int height, Component narrationMessage, boolean background) {
        this(fontrenderer, x, y, width, height, narrationMessage, background, Collections.emptySet());
    }

    public void setPossibilities(Set<IDropdownEntry<T>> possibilities) {
        this.possibilities = possibilities;
        this.visiblePossibilities = Collections.emptyList();
    }

    public int getPossibilitiesCount() {
        return this.possibilities.size();
    }

    @Nullable
    public IDropdownEntry<T> getVisiblePossibility(int index) {
        return this.visiblePossibilities.get(index);
    }

    protected void refreshDropdownList() {
        if (this.getValue().contains("\u00a7")) {
            this.setValue(this.getValue().replaceAll("\u00a7.", ""));
        }
        if (!this.possibilities.isEmpty()) {
            this.visiblePossibilities = Lists.newArrayList();
            for (IDropdownEntry<T> possibility : this.possibilities) {
                if (!possibility.getMatchString().toLowerCase().contains(this.getValue().toLowerCase())) continue;
                this.visiblePossibilities.add(possibility);
            }
            this.visiblePossibilitiesIndex = -1;
            if (!this.visiblePossibilities.isEmpty()) {
                this.selectedDropdownPossibility = this.visiblePossibilities.stream().filter(e -> e.getMatchString().equals(this.getValue())).findFirst().orElse(null);
            }
            if (this.dropdownEntryListener != null) {
                this.dropdownEntryListener.onSetDropdownPossiblity(this.selectedDropdownPossibility);
            }
        }
    }

    public void setFocused(boolean isFocusedIn) {
        super.setFocused(isFocusedIn);
        if (isFocusedIn) {
            this.refreshDropdownList();
        }
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (super.charTyped(typedChar, keyCode)) {
            this.refreshDropdownList();
            return true;
        }
        return false;
    }

    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        this.selectedDropdownPossibility = null;
        if (!this.possibilities.isEmpty()) {
            switch (typedChar) {
                case 265: {
                    this.visiblePossibilitiesIndex = this.visiblePossibilitiesIndex >= 0 ? --this.visiblePossibilitiesIndex : this.visiblePossibilities.size() - 1;
                    return true;
                }
                case 258: 
                case 264: {
                    this.visiblePossibilitiesIndex = this.visiblePossibilitiesIndex < this.visiblePossibilities.size() - 1 ? ++this.visiblePossibilitiesIndex : 0;
                    return true;
                }
                case 257: 
                case 262: 
                case 335: {
                    if (this.visiblePossibilitiesIndex < 0 || this.visiblePossibilitiesIndex >= this.visiblePossibilities.size()) break;
                    this.selectVisiblePossibility(this.visiblePossibilitiesIndex);
                    return true;
                }
            }
        }
        if (super.keyPressed(typedChar, keyCode, modifiers)) {
            this.refreshDropdownList();
            return true;
        }
        return false;
    }

    protected void selectVisiblePossibility(int index) {
        this.visiblePossibilitiesIndex = index;
        this.selectPossibility(this.visiblePossibilities.get(this.visiblePossibilitiesIndex));
    }

    public void selectPossibility(@Nullable IDropdownEntry<T> entry) {
        this.selectedDropdownPossibility = entry;
        this.setValue(this.selectedDropdownPossibility != null ? this.selectedDropdownPossibility.getDisplayString().getString() : "");
        this.visiblePossibilities = Lists.newArrayList();
        this.visiblePossibilitiesIndex = -1;
        if (this.dropdownEntryListener != null) {
            this.dropdownEntryListener.onSetDropdownPossiblity(this.selectedDropdownPossibility);
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.setTextColor(this.selectedDropdownPossibility == null ? Helpers.RGBToInt((int)220, (int)10, (int)10) : 0xE0E0E0);
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.isVisible() && this.isFocused()) {
            Font fontRenderer = Minecraft.getInstance().font;
            Objects.requireNonNull(fontRenderer);
            int yOffset = 9 + 3;
            int x = this.getX();
            int y = this.getY() + yOffset;
            int width = this.getWidth() + 9;
            int startIndex = Math.max(0, Math.min(this.visiblePossibilitiesIndex, this.visiblePossibilities.size() - this.getDropdownSize()));
            int endIndex = Math.min(startIndex + this.getDropdownSize(), this.visiblePossibilities.size());
            int cy = y;
            if (startIndex > 0) {
                guiGraphics.fill(x, cy - 1, x + width, cy + 11, -6250336);
                guiGraphics.fill(x - 1, cy, x + width - 1, cy + 10, -16777216);
                fontRenderer.drawInBatch("...", (float)x + 1.0f, (float)cy + 2.0f, this.disabledColor, true, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                cy += 10;
            }
            for (int i = startIndex; i < endIndex; ++i) {
                IDropdownEntry<T> dropdownEntry = this.visiblePossibilities.get(i);
                MutableComponent possibility = dropdownEntry.getDisplayString();
                List displayPossibility = fontRenderer.split((FormattedText)possibility, width);
                boolean active = this.visiblePossibilitiesIndex == i;
                int entryHeight = yOffset;
                boolean addTooltip = active && MinecraftHelpers.isShifted() || RenderHelpers.isPointInRegion((int)x, (int)cy, (int)this.getWidth(), (int)yOffset, (double)mouseX, (double)mouseY);
                List<MutableComponent> tooltipLines = null;
                if (addTooltip) {
                    tooltipLines = dropdownEntry.getTooltip();
                    entryHeight += tooltipLines.size() * yOffset;
                }
                guiGraphics.fill(x, cy - 1, x + width, cy + entryHeight + 1, -6250336);
                guiGraphics.fill(x - 1, cy, x + width - 1, cy + entryHeight, -16777216);
                fontRenderer.drawInBatch((FormattedCharSequence)displayPossibility.get(0), (float)x + 1.0f, (float)cy + 2.0f, active ? this.enabledColor : this.disabledColor, true, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                if (addTooltip) {
                    int tooltipLineOffsetY = 2;
                    for (Component component : tooltipLines) {
                        fontRenderer.drawInBatch(component.getString(), (float)x + 1.0f, (float)cy + (float)(tooltipLineOffsetY += yOffset), this.enabledColor, true, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                    }
                }
                cy += entryHeight;
            }
            if (endIndex < this.visiblePossibilities.size()) {
                guiGraphics.fill(x, cy - 1, x + width, cy + 11, -6250336);
                guiGraphics.fill(x - 1, cy, x + width - 1, cy + 10, -16777216);
                fontRenderer.drawInBatch("...", (float)x + 1.0f, (float)cy + 2.0f, this.disabledColor, true, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        int i;
        if (this.isVisible() && this.isFocused() && (i = this.getHoveredVisiblePossibility(mouseX, mouseY)) >= 0) {
            this.selectVisiblePossibility(i);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public int getHoveredVisiblePossibility(double mouseX, double mouseY) {
        Font fontRenderer = Minecraft.getInstance().gui.getFont();
        Objects.requireNonNull(fontRenderer);
        int yOffset = 9 + 3;
        int x = this.getX();
        int y = this.getY() + yOffset;
        int startIndex = Math.max(0, Math.min(this.visiblePossibilitiesIndex, this.visiblePossibilities.size() - this.getDropdownSize()));
        int endIndex = Math.min(startIndex + this.getDropdownSize(), this.visiblePossibilities.size());
        int cy = y;
        if (startIndex > 0) {
            cy += 10;
        }
        for (int i = startIndex; i < endIndex; ++i) {
            boolean addTooltip;
            IDropdownEntry<T> dropdownEntry = this.visiblePossibilities.get(i);
            boolean active = this.visiblePossibilitiesIndex == i;
            int entryHeight = yOffset;
            boolean bl = addTooltip = active && MinecraftHelpers.isShifted() || RenderHelpers.isPointInRegion((int)x, (int)cy, (int)this.getWidth(), (int)yOffset, (double)mouseX, (double)mouseY);
            if (RenderHelpers.isPointInRegion((int)x, (int)cy, (int)this.getWidth(), (int)yOffset, (double)mouseX, (double)mouseY)) {
                return i;
            }
            List<MutableComponent> tooltipLines = null;
            if (addTooltip) {
                tooltipLines = dropdownEntry.getTooltip();
                entryHeight += tooltipLines.size() * yOffset;
            }
            cy += entryHeight;
        }
        return -1;
    }

    public IDropdownEntry<T> getSelectedDropdownPossibility() {
        return this.selectedDropdownPossibility;
    }

    public int getDropdownSize() {
        return this.dropdownSize;
    }

    public void setDropdownSize(int dropdownSize) {
        this.dropdownSize = dropdownSize;
    }

    public IDropdownEntryListener<T> getDropdownEntryListener() {
        return this.dropdownEntryListener;
    }

    public void setDropdownEntryListener(IDropdownEntryListener<T> dropdownEntryListener) {
        this.dropdownEntryListener = dropdownEntryListener;
    }
}

