/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.evaluate;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;

public class EvaluationException
extends Exception {
    private final MutableComponent errorMessage;
    private boolean retryEvaluation;
    private final List<Runnable> resolutionListeners;

    public EvaluationException(MutableComponent errorMessage) {
        super(errorMessage.toString());
        this.errorMessage = errorMessage;
        this.retryEvaluation = false;
        this.resolutionListeners = Lists.newArrayList();
    }

    public MutableComponent getErrorMessage() {
        return this.errorMessage;
    }

    public void setRetryEvaluation(boolean retryEvaluation) {
        this.retryEvaluation = retryEvaluation;
    }

    public boolean isRetryEvaluation() {
        return this.retryEvaluation;
    }

    public void addResolutionListeners(Runnable listener) {
        this.resolutionListeners.add(listener);
    }

    public void resolve() {
        for (Runnable resolutionListener : Lists.newArrayList(this.resolutionListeners.listIterator())) {
            resolutionListener.run();
        }
    }
}

