/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.api.crafting;

import com.google.common.collect.Lists;
import java.util.List;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;

public class RecursiveCraftingRecipeException
extends Exception {
    private final IPrototypedIngredient prototypedIngredient;
    private final List<IRecipeDefinition> recipeStack;

    public <T, M> RecursiveCraftingRecipeException(IPrototypedIngredient prototypedIngredient) {
        this.prototypedIngredient = prototypedIngredient;
        this.recipeStack = Lists.newArrayList();
    }

    public IPrototypedIngredient getPrototypedIngredient() {
        return this.prototypedIngredient;
    }

    public List<IRecipeDefinition> getRecipeStack() {
        return this.recipeStack;
    }

    @Override
    public String getMessage() {
        return String.format("Infinite recursive recipe detected: %s", this.getPrototypedIngredient());
    }

    @Override
    public String toString() {
        return String.format("[Infinite recursive recipe detected: %s, %s]", this.getPrototypedIngredient(), this.getRecipeStack());
    }

    public void addRecipe(IRecipeDefinition recipe) {
        this.recipeStack.add(recipe);
    }

    public boolean equals(Object obj) {
        return obj instanceof RecursiveCraftingRecipeException && ((RecursiveCraftingRecipeException)obj).getPrototypedIngredient().equals((Object)this.getPrototypedIngredient()) && ((RecursiveCraftingRecipeException)obj).getRecipeStack().equals(this.getRecipeStack());
    }
}

