/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common.mods;

import atomicstryker.infernalmobs.common.MobModifier;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;

public class MM_Rust
extends MobModifier {
    private static String[] suffix = new String[]{"ofDecay", "theEquipmentHaunter"};
    private static String[] prefix = new String[]{"rusting", "decaying"};

    public MM_Rust() {
    }

    public MM_Rust(MobModifier next) {
        super(next);
    }

    @Override
    public String getModName() {
        return "Rust";
    }

    @Override
    public float onHurt(LivingEntity mob, DamageSource source, float damage) {
        Player p;
        Entity entity;
        if (this.isDirectAttack(source) && (entity = source.getDirectEntity()) instanceof Player && !this.isCreativePlayer((Entity)(p = (Player)entity))) {
            p.getInventory().getSelected().hurtAndBreak(4, (LivingEntity)source.getDirectEntity(), LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
        }
        return super.onHurt(mob, source, damage);
    }

    @Override
    public float onAttack(LivingEntity entity, DamageSource source, float damage) {
        if (entity instanceof Player) {
            this.hurtArmor((Player)entity, entity.damageSources().magic(), damage * 3.0f);
        }
        return super.onAttack(entity, source, damage);
    }

    private void hurtArmor(Player player, DamageSource damageSource, float pDamageAmount) {
        if (pDamageAmount > 0.0f) {
            EquipmentSlot[] slots;
            int i = (int)Math.max(1.0f, pDamageAmount / 4.0f);
            for (EquipmentSlot equipmentSlot : slots = new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD}) {
                ItemStack itemstack = player.getItemBySlot(equipmentSlot);
                if (!(itemstack.getItem() instanceof ArmorItem) || !itemstack.canBeHurtBy(damageSource)) continue;
                itemstack.hurtAndBreak(i, (LivingEntity)player, equipmentSlot);
            }
        }
    }

    @Override
    protected String[] getModNameSuffix() {
        return suffix;
    }

    @Override
    protected String[] getModNamePrefix() {
        return prefix;
    }
}

