/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common.mods;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.mods.MM_Webber;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class MM_Blastoff
extends MobModifier {
    private static final long coolDown = 15000L;
    private static Class<?>[] modBans = new Class[]{MM_Webber.class};
    private static String[] suffix = new String[]{"ofMissionControl", "theNASA", "ofWEE"};
    private static String[] prefix = new String[]{"thumping", "trolling", "byebye"};
    private long nextAbilityUse = 0L;

    public MM_Blastoff() {
    }

    public MM_Blastoff(MobModifier next) {
        super(next);
    }

    @Override
    public String getModName() {
        return "Blastoff";
    }

    @Override
    public boolean onUpdate(LivingEntity mob) {
        if (this.hasSteadyTarget() && this.getMobTarget() instanceof Player) {
            this.tryAbility(mob, this.getMobTarget());
        }
        return super.onUpdate(mob);
    }

    @Override
    public float onHurt(LivingEntity mob, DamageSource source, float damage) {
        if (source.getDirectEntity() != null && source.getDirectEntity() instanceof LivingEntity) {
            this.tryAbility(mob, (LivingEntity)source.getDirectEntity());
        }
        return super.onHurt(mob, source, damage);
    }

    private void tryAbility(LivingEntity mob, LivingEntity target) {
        if (target == null || !this.canMobSeeTarget(mob, target)) {
            return;
        }
        long time = System.currentTimeMillis();
        if (time > this.nextAbilityUse) {
            this.nextAbilityUse = time + 15000L;
            mob.level().playSound(null, mob.blockPosition(), SoundEvents.SLIME_JUMP, SoundSource.HOSTILE, 1.0f + mob.getRandom().nextFloat(), mob.getRandom().nextFloat() * 0.7f + 0.3f);
            if (target.level().isClientSide || !(target instanceof ServerPlayer)) {
                target.push(0.0, 1.1, 0.0);
            } else {
                InfernalMobsCore.instance().sendVelocityPacket((ServerPlayer)target, 0.0f, 1.1f, 0.0f);
            }
        }
    }

    @Override
    public Class<?>[] getModsNotToMixWith() {
        return modBans;
    }

    @Override
    protected String[] getModNameSuffix() {
        return suffix;
    }

    @Override
    protected String[] getModNamePrefix() {
        return prefix;
    }
}

