/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;

public abstract class MobModifier {
    private static final int TARGETING_TICKS_BEFORE_ATTACK = 30;
    protected MobModifier nextMod;
    private float actualHealth = 100.0f;
    private String[] bufferedNames;
    private float actualMaxHealth = -1.0f;
    private LivingEntity attackTarget;
    private LivingEntity previousAttackTarget;
    private int targetingTicksSteadyTarget = 0;
    private int bufferedSize = 0;
    private String bufferedEntityName;

    public MobModifier() {
    }

    protected MobModifier(MobModifier nxtMod) {
        this();
        this.nextMod = nxtMod;
    }

    public abstract String getModName();

    public String getLinkedModName() {
        return I18n.get((String)("translation.infernalmobs:mod." + this.getModName()), (Object[])new Object[0]) + " " + (this.nextMod != null ? this.nextMod.getLinkedModName() : "");
    }

    public String getLinkedModNameUntranslated() {
        return this.getModName() + " " + (this.nextMod != null ? this.nextMod.getLinkedModNameUntranslated() : "");
    }

    public String[] getDisplayNames() {
        if (this.bufferedNames == null) {
            String[] allMods = this.getLinkedModName().split(" ");
            int index = 0;
            int j = 0;
            this.bufferedNames = new String[3];
            this.bufferedNames[index] = "";
            for (String m : allMods) {
                this.bufferedNames[index] = this.bufferedNames[index] + " " + m;
                if (++j % 5 != 0 || index + 1 >= this.bufferedNames.length) continue;
                this.bufferedNames[++index] = "";
            }
        }
        return this.bufferedNames;
    }

    public boolean containsModifierClass(Class<?> checkfor) {
        return checkfor.equals(this.getClass()) || this.nextMod != null && this.nextMod.containsModifierClass(checkfor);
    }

    public void onSpawningCompleteStoreModsAndBuffHealth(LivingEntity entity) {
        String oldTag = entity.getPersistentData().getString(InfernalMobsCore.instance().getNBTTag());
        if (!oldTag.isEmpty() && !oldTag.equals(this.getLinkedModNameUntranslated())) {
            InfernalMobsCore.LOGGER.info("Infernal Mobs tag mismatch!! Was [{}}], now trying to set [{}}] \n", (Object)oldTag, (Object)this.getLinkedModNameUntranslated());
        }
        entity.getPersistentData().putString(InfernalMobsCore.instance().getNBTTag(), this.getLinkedModNameUntranslated());
        this.increaseMaxHealthForMobIfNeeded(entity);
    }

    public boolean onDeath() {
        this.attackTarget = null;
        return this.nextMod != null && this.nextMod.onDeath();
    }

    public void onDropItems(LivingEntity moddedMob, DamageSource killSource, Collection<ItemEntity> drops, boolean recentlyHit) {
        if (recentlyHit) {
            InfernalMobsCore.instance().dropLootForEnt(moddedMob, this);
        }
    }

    public void onSetAttackTarget(LivingEntity target) {
        this.previousAttackTarget = this.attackTarget;
        this.attackTarget = target;
        if (this.previousAttackTarget != target) {
            this.targetingTicksSteadyTarget = 0;
        }
        if (this.nextMod != null) {
            this.nextMod.onSetAttackTarget(target);
        }
    }

    public float onAttack(LivingEntity entity, DamageSource source, float amount) {
        if (this.nextMod != null) {
            return this.nextMod.onAttack(entity, source, amount);
        }
        return amount;
    }

    protected boolean isDirectAttack(DamageSource source) {
        return source.getDirectEntity() != null && source.getDirectEntity() instanceof LivingEntity;
    }

    public float onHurt(LivingEntity mob, DamageSource source, float amount) {
        if (this.nextMod != null) {
            amount = this.nextMod.onHurt(mob, source, amount);
        } else if (source.getDirectEntity() != null && source.getDirectEntity().level().isClientSide && source.getDirectEntity() instanceof Player) {
            InfernalMobsCore.instance().sendHealthRequestPacket(source.getDirectEntity().getName().getString(), mob);
        }
        return amount;
    }

    public boolean onFall(float distance) {
        return this.nextMod != null && this.nextMod.onFall(distance);
    }

    public void onJump(LivingEntity entityLiving) {
        if (this.nextMod != null) {
            this.nextMod.onJump(entityLiving);
        }
    }

    public boolean onUpdate(LivingEntity mob) {
        if (this.nextMod != null) {
            return this.nextMod.onUpdate(mob);
        }
        if (this.attackTarget == null) {
            this.attackTarget = mob.level().getNearestPlayer((Entity)mob, 7.5);
        }
        if (this.attackTarget != null && (!this.attackTarget.isAlive() || this.attackTarget.distanceTo((Entity)mob) > 15.0f)) {
            this.attackTarget = null;
        }
        return false;
    }

    public void onKnockBack(LivingKnockBackEvent event) {
        if (this.nextMod != null) {
            this.nextMod.onKnockBack(event);
        }
    }

    public boolean hasSteadyTarget() {
        if (this.attackTarget != null) {
            this.targetingTicksSteadyTarget = this.isCreativePlayer((Entity)this.attackTarget) ? 0 : ++this.targetingTicksSteadyTarget;
            return this.targetingTicksSteadyTarget > 30;
        }
        return false;
    }

    protected boolean isCreativePlayer(Entity entity) {
        Player player;
        return entity instanceof Player && (player = (Player)entity).isCreative();
    }

    public float getActualHealth(LivingEntity mob) {
        return this.actualHealth;
    }

    private void increaseMaxHealthForMobIfNeeded(LivingEntity mob) {
        if (mob.level().isClientSide) {
            return;
        }
        float storedMaxHealth = mob.getPersistentData().getFloat("infernalMaxHealth");
        if (storedMaxHealth < 1.0f) {
            this.actualHealth = this.actualMaxHealth = (float)(InfernalMobsCore.instance().getMobClassMaxHealth(mob) * (double)this.getModSize() * InfernalMobsCore.instance().getMobModHealthFactor());
            InfernalMobsCore.instance().setEntityHealthPastMax(mob, this.actualHealth);
            mob.getPersistentData().putFloat("infernalMaxHealth", this.actualMaxHealth);
        } else {
            this.actualMaxHealth = storedMaxHealth;
        }
    }

    public float getActualMaxHealth(LivingEntity mob) {
        if (!mob.level().isClientSide && this.actualMaxHealth < 1.0f) {
            this.actualMaxHealth = mob.getPersistentData().getFloat("infernalMaxHealth");
        }
        return this.actualMaxHealth;
    }

    public void setActualHealth(float health, float maxHealth) {
        this.actualHealth = health;
        this.actualMaxHealth = maxHealth;
    }

    protected LivingEntity getMobTarget() {
        return this.attackTarget;
    }

    public Class<?>[] getBlackListMobClasses() {
        return null;
    }

    public Class<?>[] getModsNotToMixWith() {
        return null;
    }

    public boolean equals(Object o) {
        return o instanceof MobModifier && ((MobModifier)o).getModName().equals(this.getModName());
    }

    public int getModSize() {
        if (this.bufferedSize == 0) {
            this.bufferedSize = 1;
            MobModifier nextmod = this.nextMod;
            while (nextmod != null) {
                ++this.bufferedSize;
                nextmod = nextmod.nextMod;
            }
        }
        return this.bufferedSize;
    }

    protected String[] getModNamePrefix() {
        return null;
    }

    protected String[] getModNameSuffix() {
        return null;
    }

    public String getEntityDisplayName(LivingEntity target) {
        if (this.bufferedEntityName == null) {
            String entTrans;
            String entLoc;
            Object buffer = BuiltInRegistries.ENTITY_TYPE.getKey((Object)target.getType()).getPath();
            String[] subStrings = ((String)buffer).split("\\.");
            if (subStrings.length > 1) {
                buffer = subStrings[subStrings.length - 1];
            }
            if (!(entLoc = "translation.infernalmobs:entity." + (String)(buffer = ((String)buffer).replaceFirst("Entity", ""))).equals(entTrans = I18n.get((String)entLoc, (Object[])new Object[0]))) {
                buffer = entTrans;
            }
            buffer = ((String)buffer).substring(0, 1).toUpperCase() + ((String)buffer).substring(1);
            int size = this.getModSize();
            MobModifier mod = this;
            for (int randomMod = target.getRandom().nextInt(this.getModSize()); randomMod > 0; --randomMod) {
                mod = mod.nextMod;
            }
            String modprefix = "";
            if (mod.getModNamePrefix() != null) {
                modprefix = mod.getModNamePrefix()[target.getRandom().nextInt(mod.getModNamePrefix().length)];
                modprefix = I18n.get((String)("translation.infernalmobs:prefix." + modprefix), (Object[])new Object[0]);
            }
            String prefix = size <= 5 ? String.valueOf(ChatFormatting.AQUA) + I18n.get((String)"translation.infernalmobs:rareClass", (Object[])new Object[0]) : (size <= 10 ? String.valueOf(ChatFormatting.YELLOW) + I18n.get((String)"translation.infernalmobs:ultraClass", (Object[])new Object[0]) : String.valueOf(ChatFormatting.GOLD) + I18n.get((String)"translation.infernalmobs:infernalClass", (Object[])new Object[0]));
            buffer = String.format("%s %s %s", prefix, modprefix, buffer);
            if (size > 1) {
                MobModifier mobModifier = mod = mod.nextMod != null ? mod.nextMod : this;
                if (mod.getModNameSuffix() != null) {
                    String pickedSuffix = mod.getModNameSuffix()[target.getRandom().nextInt(mod.getModNameSuffix().length)];
                    pickedSuffix = I18n.get((String)("translation.infernalmobs:suffix." + pickedSuffix), (Object[])new Object[0]);
                    buffer = String.format("%s %s", buffer, pickedSuffix);
                }
            }
            this.bufferedEntityName = buffer;
        }
        return this.bufferedEntityName;
    }

    public void resetModifiedVictim(Player victim) {
    }

    protected boolean canMobSeeTarget(LivingEntity mob, LivingEntity target) {
        if (mob.distanceTo((Entity)target) < 20.0f) {
            if (mob instanceof Mob) {
                return ((Mob)mob).getSensing().hasLineOfSight((Entity)target);
            }
            return true;
        }
        return false;
    }
}

