/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.Logger;

public class ItemConfigHelper {
    private final List<ItemStack> itemStackList = new ArrayList<ItemStack>();

    public ItemConfigHelper(List<? extends String> items, Logger logger, RegistryAccess registryAccess) {
        for (String string : items) {
            try {
                CompoundTag nbt = TagParser.parseTag((String)string);
                ItemStack itemStack = ItemStack.parseOptional((HolderLookup.Provider)registryAccess, (CompoundTag)nbt);
                if (!itemStack.isEmpty()) {
                    this.itemStackList.add(itemStack);
                    logger.info("item config parser identified itemstack {}", (Object)itemStack);
                    continue;
                }
                logger.error("item config parser could not create itemStack from {}", (Object)string);
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
        logger.info("item config parser finished, item count: {}", (Object)this.itemStackList.size());
    }

    public static String fromItemStack(ItemStack itemStack, RegistryAccess registryAccess) {
        CompoundTag resultTag = (CompoundTag)itemStack.save((HolderLookup.Provider)registryAccess);
        return resultTag.toString();
    }

    public List<ItemStack> getItemStackList() {
        return this.itemStackList;
    }
}

