/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.SidedCache;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.apache.logging.log4j.Level;

public class InfernalCommandSpawnInfernal {
    public static final LiteralArgumentBuilder<CommandSourceStack> BUILDER = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"spawninfernal").requires(caller -> caller.hasPermission(2))).then(Commands.argument((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"y", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"z", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"entClass", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"modifiers", (ArgumentType)StringArgumentType.greedyString()).executes(caller -> {
        InfernalCommandSpawnInfernal.execute((CommandSourceStack)caller.getSource(), IntegerArgumentType.getInteger((CommandContext)caller, (String)"x"), IntegerArgumentType.getInteger((CommandContext)caller, (String)"y"), IntegerArgumentType.getInteger((CommandContext)caller, (String)"z"), StringArgumentType.getString((CommandContext)caller, (String)"entClass"), StringArgumentType.getString((CommandContext)caller, (String)"modifiers"));
        return 1;
    }))))));

    private static void execute(CommandSourceStack source, int x, int y, int z, String entClassName, String modifiers) {
        Optional chosenType = BuiltInRegistries.ENTITY_TYPE.getOptional(ResourceLocation.parse((String)entClassName));
        if (chosenType.isEmpty() || ((EntityType)chosenType.get()).getCategory().isFriendly() || ((EntityType)chosenType.get()).getCategory().isPersistent()) {
            source.sendFailure((Component)Component.literal((String)("Invalid SpawnInfernal command, no Entity Resource [" + entClassName + "] known or noncombat entity type")));
            return;
        }
        LivingEntity mob = (LivingEntity)((EntityType)chosenType.get()).create((net.minecraft.world.level.Level)source.getLevel());
        if (mob == null) {
            source.sendFailure((Component)Component.literal((String)("Invalid SpawnInfernal command, failed to create [" + entClassName + "] instance in world")));
        }
        mob.setPos((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        source.getLevel().addFreshEntity((Entity)mob);
        SidedCache.getInfernalMobs(mob.level()).remove(mob);
        InfernalMobsCore.instance().addEntityModifiersByString(mob, modifiers);
        MobModifier mod = InfernalMobsCore.getMobModifiers(mob);
        if (mod != null) {
            InfernalMobsCore.LOGGER.log(Level.INFO, source.getTextName() + " spawned: " + InfernalMobsCore.getMobModifiers(mob).getLinkedModNameUntranslated() + " at [" + x + "|" + y + "|" + z + "]");
        } else {
            source.sendFailure((Component)Component.literal((String)("Error adding Infernal Modifier " + modifiers + " to mob " + String.valueOf(mob))));
        }
    }
}

