/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.client;

import atomicstryker.infernalmobs.client.OverlayChoking;
import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.SidedCache;
import atomicstryker.infernalmobs.common.mods.MM_Gravity;
import atomicstryker.infernalmobs.common.network.AirPacket;
import atomicstryker.infernalmobs.common.network.HealthPacket;
import atomicstryker.infernalmobs.common.network.KnockBackPacket;
import atomicstryker.infernalmobs.common.network.MobModsPacket;
import atomicstryker.infernalmobs.common.network.VelocityPacket;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class InfernalMobsClient {
    private static InfernalMobsClient INSTANCE;
    private static Minecraft mc;

    public InfernalMobsClient() {
        INSTANCE = this;
    }

    public static InfernalMobsClient instance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void playerLoginToServer(ClientPlayerNetworkEvent.LoggingIn evt) {
        mc = Minecraft.getInstance();
        InfernalMobsCore.instance().initIfNeeded(evt.getPlayer().level());
    }

    @SubscribeEvent
    public void onEntityJoinedWorld(EntityJoinLevelEvent event) {
        if (event.getLevel().isClientSide && InfernalMobsClient.mc.player != null && (event.getEntity() instanceof Mob || event.getEntity() instanceof LivingEntity && event.getEntity() instanceof Enemy)) {
            MobModsPacket mobModsPacket = new MobModsPacket(InfernalMobsClient.mc.player.getName().getString(), event.getEntity().getId(), 0);
            PacketDistributor.sendToServer((CustomPacketPayload)mobModsPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
            InfernalMobsCore.LOGGER.trace("onEntityJoinedWorld {}, ent-id {} querying modifiers from server", (Object)event.getEntity(), (Object)event.getEntity().getId());
        }
    }

    @SubscribeEvent
    public void playerLoggedOut(ClientPlayerNetworkEvent.LoggingOut evt) {
        if (evt.getPlayer() != null) {
            SidedCache.getInfernalMobs(evt.getPlayer().level()).clear();
        }
    }

    public void onHealthPacketForClient(HealthPacket healthPacket, IPayloadContext context) {
        mc.submitAsync(() -> this.onHealthPacket(healthPacket.entID(), healthPacket.health(), healthPacket.maxhealth()));
    }

    private void onHealthPacket(int entID, float health, float maxhealth) {
        MobModifier mod;
        Entity ent = Minecraft.getInstance().level.getEntity(entID);
        if (ent instanceof LivingEntity && (mod = InfernalMobsCore.getMobModifiers((LivingEntity)ent)) != null) {
            mod.setActualHealth(health, maxhealth);
        }
    }

    public void onKnockBackPacket(KnockBackPacket knockBackPacket, IPayloadContext playPayloadContext) {
        mc.submitAsync(() -> MM_Gravity.knockBack((LivingEntity)InfernalMobsClient.mc.player, knockBackPacket.xv(), knockBackPacket.zv()));
    }

    public void onMobModsPacketToClient(MobModsPacket mobModsPacket, IPayloadContext playPayloadContext) {
        InfernalMobsCore.instance().addRemoteEntityModifiers((Level)InfernalMobsClient.mc.level, mobModsPacket.entID(), mobModsPacket.stringData());
    }

    public void onAirPacket(AirPacket airPacket, IPayloadContext playPayloadContext) {
        mc.submitAsync(() -> OverlayChoking.handleAirPacket(airPacket, playPayloadContext));
    }

    public void onVelocityPacket(VelocityPacket velocityPacket, IPayloadContext playPayloadContext) {
        mc.submitAsync(() -> InfernalMobsClient.mc.player.push((double)velocityPacket.xv(), (double)velocityPacket.yv(), (double)velocityPacket.zv()));
    }

    public static File getMcFolder() {
        return Minecraft.getInstance().gameDirectory;
    }
}

