/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.entity.client;

import com.buuz135.industrial.entity.InfinityNukeEntity;
import com.buuz135.industrial.entity.client.InfinityNukeModel;
import com.buuz135.industrial.entity.client.InfinityNukeModelArmed;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class InfinityNukeRenderer
extends EntityRenderer<InfinityNukeEntity> {
    public static final ResourceLocation NUKE = ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"textures/entity/infinity_nuke_entity.png");
    private final InfinityNukeModel nukeModel;
    private final InfinityNukeModelArmed nukeModelArmed;
    private final InfinityNukeModelArmed nukeModelArmedBig;
    public static final ModelLayerLocation NUKE_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"infinity_nuke_entity"), "main");
    public static final ModelLayerLocation NUKE_ARMED_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"infinity_nuke_entity"), "armed");
    public static final ModelLayerLocation NUKE_ARMED_BIG_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"infinity_nuke_entity"), "armed_big");

    public InfinityNukeRenderer(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
        this.nukeModel = new InfinityNukeModel(p_174008_.bakeLayer(NUKE_LAYER));
        this.nukeModelArmed = new InfinityNukeModelArmed(p_174008_.bakeLayer(NUKE_ARMED_LAYER));
        this.nukeModelArmedBig = new InfinityNukeModelArmed(p_174008_.bakeLayer(NUKE_ARMED_BIG_LAYER));
    }

    public void render(InfinityNukeEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.pushPose();
        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot()) - 180.0f));
        matrixStackIn.translate(0.0, -1.35, 0.05);
        VertexConsumer ivertexbuilder = ItemRenderer.getFoilBufferDirect((MultiBufferSource)bufferIn, (RenderType)RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(entityIn)), (boolean)false, (boolean)false);
        if (entityIn.isDataArmed()) {
            if (entityIn.isDataExploding()) {
                double time = 7 + entityIn.getCommandSenderWorld().getRandom().nextInt(50);
                matrixStackIn.translate((entityIn.getCommandSenderWorld().getRandom().nextDouble() - 0.5) / time, 0.0, (entityIn.getCommandSenderWorld().getRandom().nextDouble() - 0.5) / time);
            }
            this.nukeModelArmed.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, 0xFFFFFF);
            if (entityIn.isDataExploding() && entityIn.level().getRandom().nextDouble() < 0.96) {
                float f = partialTicks + (float)entityIn.getDataTicksExploding() + 10.0f;
                ivertexbuilder = ItemRenderer.getFoilBufferDirect((MultiBufferSource)bufferIn, (RenderType)RenderType.energySwirl((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"textures/block/mycelial_clean.png"), (float)(f * ((float)entityIn.getDataTicksExploding() / 50000.0f)), (float)(f * ((float)entityIn.getDataTicksExploding() / 50000.0f))), (boolean)false, (boolean)false);
                this.nukeModelArmedBig.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, 0xFFFFFF);
            }
        } else {
            this.nukeModel.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, 0xFFFFFF);
        }
        matrixStackIn.popPose();
        super.render((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(InfinityNukeEntity entity) {
        return NUKE;
    }
}

