/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.transporter;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.transporter.FilteredTransporterType;
import com.buuz135.industrial.api.transporter.TransporterType;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.block.transportstorage.tile.TransporterTile;
import com.buuz135.industrial.block.transportstorage.transporter.filter.ItemFilter;
import com.buuz135.industrial.proxy.block.filter.RegulatorFilter;
import com.buuz135.industrial.utils.IndustrialTags;
import com.google.common.collect.Sets;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class TransporterWorldType
extends FilteredTransporterType<ItemStack, IItemHandler> {
    private int extractSlot = 0;

    public TransporterWorldType(IBlockContainer<?> container, TransporterTypeFactory factory, Direction side, TransporterTypeFactory.TransporterAction action) {
        super(container, factory, side, action);
    }

    @Override
    public RegulatorFilter<ItemStack, IItemHandler> createFilter() {
        return new ItemFilter(20, 20, 5, 3, 16, 64, 8192, "");
    }

    @Override
    public void update() {
        super.update();
        float speed = this.getSpeed();
        if (this.getLevel().isClientSide || (float)this.getLevel().getGameTime() % Math.max(1.0f, 4.0f - speed) != 0.0f) {
            return;
        }
        IBlockContainer container = this.getContainer();
        if (!(container instanceof TransporterTile)) {
            return;
        }
        IItemHandler origin = (IItemHandler)this.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, this.getPos().relative(this.getSide()), (Object)this.getSide().getOpposite());
        if (origin == null) {
            return;
        }
        if (this.getAction() == TransporterTypeFactory.TransporterAction.EXTRACT) {
            this.handleExtract(origin);
        } else {
            this.handleInsert(origin);
        }
    }

    private void handleExtract(@NotNull IItemHandler origin) {
        ItemStack extractSlotStack;
        if (origin.getSlots() <= 0) {
            return;
        }
        if (this.extractSlot >= origin.getSlots() || origin.getStackInSlot(this.extractSlot).isEmpty() || !this.getFilter().canExtract(origin.getStackInSlot(this.extractSlot), origin)) {
            this.findSlot(origin);
        }
        if ((extractSlotStack = origin.getStackInSlot(this.extractSlot)).isEmpty() || !this.getFilter().canExtract(extractSlotStack, origin)) {
            return;
        }
        int amount = Math.min((int)Math.ceil(1.0f * this.getEfficiency()), this.getFilter().getExtractAmount(extractSlotStack, origin));
        ItemStack extracted = origin.extractItem(this.extractSlot, amount, false);
        if (extracted.isEmpty()) {
            return;
        }
        ItemEntity item = new ItemEntity(this.getLevel(), (double)this.getPos().getX() + 0.5, (double)this.getPos().getY() + 0.2, (double)this.getPos().getZ() + 0.5, extracted);
        item.setDeltaMovement(0.0, 0.0, 0.0);
        item.setPickUpDelay(4);
        item.setItem(extracted);
        this.getLevel().addFreshEntity((Entity)item);
    }

    private void handleInsert(IItemHandler origin) {
        AABB aabb = new AABB((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ(), (double)(this.getPos().getX() + 1), (double)(this.getPos().getY() + 1), (double)(this.getPos().getZ() + 1));
        for (ItemEntity item : this.getLevel().getEntitiesOfClass(ItemEntity.class, aabb, EntitySelector.ENTITY_STILL_ALIVE)) {
            ItemStack stack = item.getItem().copy();
            ItemStack originStack = item.getItem().copy();
            int possibleAmount = Math.min((int)Math.ceil(1.0f * this.getEfficiency()), this.getFilter().getInsertAmount(stack, origin));
            if (possibleAmount <= 0) continue;
            stack.setCount(Math.min(stack.getCount(), possibleAmount));
            int preInsertionCount = stack.getCount();
            ItemStack insertItem = ItemHandlerHelper.insertItem((IItemHandler)origin, (ItemStack)stack, (boolean)false);
            originStack.shrink(preInsertionCount - insertItem.getCount());
            if (originStack.isEmpty()) {
                item.setItem(ItemStack.EMPTY);
                item.discard();
                continue;
            }
            item.setItem(originStack);
        }
    }

    private void findSlot(@NotNull IItemHandler itemHandler) {
        for (int i = this.extractSlot; i < itemHandler.getSlots(); ++i) {
            if (itemHandler.getStackInSlot(i).isEmpty() || !this.getFilter().canExtract(itemHandler.getStackInSlot(i), itemHandler)) continue;
            this.extractSlot = i;
            return;
        }
        this.extractSlot = 0;
    }

    @Override
    public void updateClient() {
        super.updateClient();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTransfer(Vector3f pos, Direction direction, int step, PoseStack stack, int combinedOverlayIn, MultiBufferSource buffer, float frame, Level level) {
        super.renderTransfer(pos, direction, step, stack, combinedOverlayIn, buffer, frame, level);
    }

    public static class Factory
    extends TransporterTypeFactory {
        public Factory() {
            super("world");
        }

        @Override
        public TransporterType create(IBlockContainer container, Direction face, TransporterTypeFactory.TransporterAction action) {
            return new TransporterWorldType(container, (TransporterTypeFactory)this, face, action);
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(Direction upgradeSide, TransporterTypeFactory.TransporterAction action) {
            return ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)("block/transporters/world_transporter_" + action.name().toLowerCase() + "_" + upgradeSide.getSerializedName().toLowerCase()));
        }

        @Override
        public Set<ResourceLocation> getTextures() {
            return Sets.newHashSet((Object[])new ResourceLocation[]{ResourceLocation.parse((String)"industrialforegoing:block/transporters/world"), ResourceLocation.parse((String)"industrialforegoing:block/base/bottom")});
        }

        @Override
        public boolean canBeAttachedAgainst(Level world, BlockPos pos, Direction face) {
            return world.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)face) != null;
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)("block/transporters/world_transporter_" + TransporterTypeFactory.TransporterAction.EXTRACT.name().toLowerCase() + "_" + Direction.NORTH.getSerializedName().toLowerCase()));
        }

        public void registerRecipe(RecipeOutput consumer) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this.getUpgradeItem(), (int)2).pattern("IPI").pattern("GMG").pattern("ICI").define(Character.valueOf('I'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('P'), (ItemLike)Items.ENDER_PEARL).define(Character.valueOf('G'), (ItemLike)Items.HOPPER).define(Character.valueOf('M'), IndustrialTags.Items.MACHINE_FRAME_PITY).define(Character.valueOf('C'), (ItemLike)Items.DROPPER).save(consumer);
        }
    }
}

