/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.conveyor;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.custom.FilterGuiComponent;
import com.buuz135.industrial.gui.component.custom.TexturedStateButtonGuiComponent;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.block.filter.ItemStackFilter;
import com.buuz135.industrial.utils.IFAttachments;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.IItemHandler;

public class ConveyorDroppingUpgrade
extends ConveyorUpgrade {
    public static VoxelShape BB = Shapes.box((double)0.1875, (double)0.0625, (double)0.1875, (double)0.8125, (double)0.063125, (double)0.8125);
    private ItemStackFilter filter = new ItemStackFilter(20, 20, 5, 3);
    private boolean whitelist = false;

    public ConveyorDroppingUpgrade(IBlockContainer container, ConveyorUpgradeFactory factory, Direction side) {
        super(container, factory, side);
    }

    @Override
    public void handleEntity(Entity entity) {
        IItemHandler handler;
        super.handleEntity(entity);
        if (entity instanceof Player) {
            return;
        }
        if (this.whitelist != this.filter.matches(entity)) {
            return;
        }
        if (entity instanceof ItemEntity && (handler = (IItemHandler)this.getWorld().getCapability(Capabilities.ItemHandler.BLOCK, this.getPos().relative(Direction.DOWN), (Object)Direction.UP)) != null && this.getBoundingBox().bounds().move(this.getPos()).inflate(0.01).intersects(entity.getBoundingBox())) {
            ItemStack stack = ((ItemEntity)entity).getItem();
            for (int i = 0; i < handler.getSlots(); ++i) {
                if ((stack = handler.insertItem(i, stack, false)).isEmpty()) {
                    entity.remove(Entity.RemovalReason.KILLED);
                    break;
                }
                ((ItemEntity)entity).setItem(stack);
            }
        }
        if (!entity.isAlive()) {
            return;
        }
        double entityHeight = entity.getBoundingBox().maxY - entity.getBoundingBox().minY;
        BlockPos pos = this.getPos().below((int)Math.ceil(entityHeight));
        boolean space = true;
        for (int y = pos.getY(); y < this.getPos().getY(); ++y) {
            if (this.getWorld().isEmptyBlock(new BlockPos(pos.getX(), y, pos.getZ()))) continue;
            space = false;
            break;
        }
        if (space) {
            entity.setDeltaMovement(0.0, 0.0, 0.0);
            entity.setPos((double)pos.getX() + 0.5, (double)pos.getY() - 0.1, (double)pos.getZ() + 0.5);
        }
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider) == null ? new CompoundTag() : super.serializeNBT(provider);
        compound.put("Filter", (Tag)this.filter.serializeNBT(provider));
        compound.putBoolean("Whitelist", this.whitelist);
        return compound;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        super.deserializeNBT(provider, nbt);
        if (nbt.contains("Filter")) {
            this.filter.deserializeNBT(provider, nbt.getCompound("Filter"));
        }
        this.whitelist = nbt.getBoolean("Whitelist");
    }

    @Override
    public VoxelShape getBoundingBox() {
        return BB;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean ignoresCollision() {
        return true;
    }

    @Override
    public void handleButtonInteraction(int buttonId, CompoundTag compound) {
        super.handleButtonInteraction(buttonId, compound);
        if (buttonId >= 0 && buttonId < this.filter.getFilter().length) {
            this.filter.setFilter(buttonId, ItemStack.parseOptional((HolderLookup.Provider)IFAttachments.registryAccess(), (CompoundTag)compound));
            this.getContainer().requestSync();
        }
        if (buttonId == 16) {
            this.whitelist = !this.whitelist;
            this.getContainer().requestSync();
        }
    }

    @Override
    public void addComponentsToGui(List<IGuiComponent> componentList) {
        super.addComponentsToGui(componentList);
        componentList.add(new FilterGuiComponent(this.filter.getLocX(), this.filter.getLocY(), this.filter.getSizeX(), this.filter.getSizeY()){

            @Override
            public IFilter getFilter() {
                return ConveyorDroppingUpgrade.this.filter;
            }
        });
        ResourceLocation res = ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"textures/gui/machines.png");
        componentList.add(new TexturedStateButtonGuiComponent(16, 133, 20, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 214, new String[]{"whitelist"}), new StateButtonInfo(1, res, 20, 214, new String[]{"blacklist"})}){

            @Override
            public int getState() {
                return ConveyorDroppingUpgrade.this.whitelist ? 0 : 1;
            }
        });
    }

    public static class Factory
    extends ConveyorUpgradeFactory {
        public Factory() {
            super("dropping");
        }

        @Override
        public ConveyorUpgrade create(IBlockContainer container, Direction face) {
            return new ConveyorDroppingUpgrade(container, this, face);
        }

        @Override
        public Set<ResourceLocation> getTextures() {
            return Collections.singleton(ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"block/conveyor_dropping_upgrade"));
        }

        @Override
        @Nonnull
        public Set<Direction> getValidFacings() {
            return DOWN;
        }

        @Override
        public Direction getSideForPlacement(Level world, BlockPos pos, Player player) {
            return Direction.DOWN;
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(Direction upgradeSide, Direction conveyorFacing) {
            return ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"block/conveyor_upgrade_dropping");
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"conveyor_dropping_upgrade");
        }

        public void registerRecipe(RecipeOutput consumer) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this.getUpgradeItem()).pattern("IPI").pattern("IDI").pattern("ICI").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('P'), (ItemLike)Blocks.IRON_BARS).define(Character.valueOf('D'), (ItemLike)Blocks.DROPPER).define(Character.valueOf('C'), (ItemLike)ModuleTransportStorage.CONVEYOR.getBlock()).save(consumer);
        }
    }
}

