/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.config.machine.resourceproduction.SludgeRefinerConfig;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class SludgeRefinerTile
extends IndustrialProcessingTile<SludgeRefinerTile> {
    private int getPowerPerTick;
    @Save
    private SidedFluidTankComponent<SludgeRefinerTile> sludge = (SidedFluidTankComponent)new SidedFluidTankComponent("sludge", SludgeRefinerConfig.maxSludgeTankSize, 31, 20, 0).setColor(DyeColor.MAGENTA).setComponentHarness((IComponentHarness)this).setTankAction(FluidTankComponent.Action.FILL).setValidator(fluidStack -> fluidStack.getFluid().isSame((Fluid)ModuleCore.SLUDGE.getSourceFluid().get()));
    @Save
    private SidedInventoryComponent<SludgeRefinerTile> output;

    public SludgeRefinerTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.SLUDGE_REFINER, 53, 40, blockPos, blockState);
        this.addTank(this.sludge);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 80, 22, 15, 1).setColor(DyeColor.ORANGE).setRange(5, 3).setInputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.output);
        this.getPowerPerTick = SludgeRefinerConfig.powerPerTick;
    }

    @Override
    public boolean canIncrease() {
        return this.sludge.getFluidAmount() >= 500;
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            Optional optionalItem = BuiltInRegistries.ITEM.getRandomElementOf(IndustrialTags.Items.SLUDGE_OUTPUT, this.level.random);
            optionalItem.ifPresent(item -> {
                if (ItemHandlerHelper.insertItem(this.output, (ItemStack)new ItemStack(item), (boolean)true).isEmpty()) {
                    this.sludge.drainForced(500, IFluidHandler.FluidAction.EXECUTE);
                    ItemHandlerHelper.insertItem(this.output, (ItemStack)new ItemStack(item), (boolean)false);
                }
            });
        };
    }

    protected EnergyStorageComponent<SludgeRefinerTile> createEnergyStorage() {
        return new EnergyStorageComponent(SludgeRefinerConfig.maxStoredPower, 10, 20);
    }

    @Override
    protected int getTickPower() {
        return this.getPowerPerTick;
    }

    @Nonnull
    public SludgeRefinerTile getSelf() {
        return this;
    }
}

