/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.misc.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.config.machine.misc.EnchantmentApplicatorConfig;
import com.buuz135.industrial.gui.component.TextureScreenAddon;
import com.buuz135.industrial.module.ModuleMisc;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.util.TagUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Pair;

public class EnchantmentApplicatorTile
extends IndustrialProcessingTile<EnchantmentApplicatorTile> {
    @Save
    private SidedInventoryComponent<EnchantmentApplicatorTile> inputFirst;
    @Save
    private SidedInventoryComponent<EnchantmentApplicatorTile> inputSecond;
    @Save
    private SidedInventoryComponent<EnchantmentApplicatorTile> output;
    @Save
    private SidedFluidTankComponent<EnchantmentApplicatorTile> tank = (SidedFluidTankComponent)new SidedFluidTankComponent("essence", EnchantmentApplicatorConfig.tankSize, 34, 20, 0).setColor(DyeColor.LIME).setComponentHarness((IComponentHarness)this).setOnContentChange(() -> this.syncObject(this.tank)).setValidator(fluidStack -> TagUtil.hasTag((Registry)BuiltInRegistries.FLUID, (Object)fluidStack.getFluid(), IndustrialTags.Fluids.EXPERIENCE));

    public EnchantmentApplicatorTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleMisc.ENCHANTMENT_APPLICATOR, 112, 40, blockPos, blockState);
        this.addTank(this.tank);
        this.inputFirst = (SidedInventoryComponent)new SidedInventoryComponent("inputFirst", 60, 40, 1, 1).setColor(DyeColor.BLUE).setInputFilter((stack, integer) -> !stack.getItem().equals(Items.ENCHANTED_BOOK)).setSlotLimit(1).setOutputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.inputFirst);
        this.inputSecond = (SidedInventoryComponent)new SidedInventoryComponent("inputSecond", 85, 40, 1, 2).setColor(DyeColor.MAGENTA).setSlotLimit(1).setOutputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.inputSecond);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 145, 40, 1, 3).setColor(DyeColor.ORANGE).setInputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.output);
    }

    public static int getMatchingAmount(IFluidHandler capability) {
        int amount = 0;
        for (int i = 0; i < capability.getTanks(); ++i) {
            if (!capability.getFluidInTank(i).is(IndustrialTags.Fluids.EXPERIENCE)) continue;
            amount += capability.getFluidInTank(i).getAmount();
        }
        return amount;
    }

    public static int drainAmount(int amount, IFluidHandler capability) {
        for (int i = 0; i < capability.getTanks(); ++i) {
            if (!capability.getFluidInTank(i).is(IndustrialTags.Fluids.EXPERIENCE)) continue;
            amount -= capability.drain(amount, IFluidHandler.FluidAction.EXECUTE).getAmount();
        }
        return amount;
    }

    public static int getEssenceConsumed(int experienceLevel) {
        long xp = 0L;
        if (experienceLevel >= 0 && experienceLevel <= 16) {
            xp = (long)(Math.pow(experienceLevel, 2.0) + (double)(6 * experienceLevel));
        }
        if (experienceLevel >= 17 && experienceLevel <= 31) {
            xp = (long)(2.5 * Math.pow(experienceLevel, 2.0) - 40.5 * (double)experienceLevel + 360.0);
        }
        if (experienceLevel >= 32) {
            xp = (long)(4.5 * Math.pow(experienceLevel, 2.0) - 162.5 * (double)experienceLevel + 2220.0);
        }
        return (xp *= 20L) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)xp;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        ResourceLocation res = ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"textures/gui/machines.png");
        this.addGuiAddonFactory(() -> new TextureScreenAddon(this, 158, 4, 14, 14, res, 96, 233){

            @Override
            public List<Component> getTooltipLines() {
                ArrayList<Component> components = new ArrayList<Component>();
                components.add((Component)Component.translatable((String)"text.industrialforegoing.tooltip.accepts_fluid_on_top"));
                return components;
            }
        });
    }

    @Override
    public boolean canIncrease() {
        Pair<ItemStack, Integer> output = this.updateRepairOutput();
        long amount = this.tank.getFluidAmount();
        IFluidHandler capability = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.worldPosition.above(), (Object)Direction.DOWN);
        if (capability != null) {
            amount += (long)EnchantmentApplicatorTile.getMatchingAmount(capability);
        }
        return !((ItemStack)output.getLeft()).isEmpty() && amount >= (long)EnchantmentApplicatorTile.getEssenceConsumed((Integer)output.getRight()) && this.output.getStackInSlot(0).isEmpty();
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            Pair<ItemStack, Integer> output = this.updateRepairOutput();
            this.inputFirst.setStackInSlot(0, ItemStack.EMPTY);
            this.inputSecond.getStackInSlot(0).shrink(1);
            this.output.setStackInSlot(0, (ItemStack)output.getLeft());
            int amount = EnchantmentApplicatorTile.getEssenceConsumed((Integer)output.getRight());
            IFluidHandler capability = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.worldPosition.above(), (Object)Direction.DOWN);
            if (capability != null) {
                amount = EnchantmentApplicatorTile.drainAmount(amount, capability);
            }
            if (amount > 0) {
                this.tank.drainForced(amount, IFluidHandler.FluidAction.EXECUTE);
            }
        };
    }

    @Override
    protected int getTickPower() {
        return EnchantmentApplicatorConfig.powerPerTick;
    }

    public EnchantmentApplicatorTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<EnchantmentApplicatorTile> createEnergyStorage() {
        return new EnergyStorageComponent(EnchantmentApplicatorConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return EnchantmentApplicatorConfig.maxProgress;
    }

    public Pair<ItemStack, Integer> updateRepairOutput() {
        ItemStack inputFirst = this.inputFirst.getStackInSlot(0);
        int maximumCost = 1;
        int i = 0;
        int j = 0;
        int k = 0;
        if (inputFirst.isEmpty()) {
            return Pair.of((Object)ItemStack.EMPTY, (Object)0);
        }
        ItemStack inputFirstCopy = inputFirst.copy();
        ItemStack inputSecond = this.inputSecond.getStackInSlot(0);
        ItemEnchantments.Mutable map = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)inputFirstCopy));
        j = j + (Integer)inputFirst.get(DataComponents.REPAIR_COST) + (inputSecond.isEmpty() ? 0 : (Integer)inputSecond.get(DataComponents.REPAIR_COST));
        boolean addEnchantment = false;
        if (!inputSecond.isEmpty()) {
            addEnchantment = inputSecond.has(DataComponents.STORED_ENCHANTMENTS);
            if (inputFirstCopy.isDamageableItem() && inputFirstCopy.getItem().isValidRepairItem(inputFirst, inputSecond)) {
                int l2 = Math.min(inputFirstCopy.getDamageValue(), inputFirstCopy.getMaxDamage() / 4);
                if (l2 <= 0) {
                    return Pair.of((Object)ItemStack.EMPTY, (Object)0);
                }
                for (int i3 = 0; l2 > 0 && i3 < inputSecond.getCount(); ++i3) {
                    int j3 = inputFirstCopy.getDamageValue() - l2;
                    inputFirstCopy.setDamageValue(j3);
                    ++i;
                    l2 = Math.min(inputFirstCopy.getDamageValue(), inputFirstCopy.getMaxDamage() / 4);
                }
            } else {
                if (!(addEnchantment || inputFirstCopy.getItem() == inputSecond.getItem() && inputFirstCopy.isDamageableItem())) {
                    return Pair.of((Object)ItemStack.EMPTY, (Object)0);
                }
                if (inputFirstCopy.isDamageableItem() && !addEnchantment) {
                    int l = inputFirst.getMaxDamage() - inputFirst.getDamageValue();
                    int i1 = inputSecond.getMaxDamage() - inputSecond.getDamageValue();
                    int j1 = i1 + inputFirstCopy.getMaxDamage() * 12 / 100;
                    int k1 = l + j1;
                    int l1 = inputFirstCopy.getMaxDamage() - k1;
                    if (l1 < 0) {
                        l1 = 0;
                    }
                    if (l1 < inputFirstCopy.getDamageValue()) {
                        inputFirstCopy.setDamageValue(l1);
                        i += 2;
                    }
                }
                ItemEnchantments map1 = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)inputSecond);
                boolean flag2 = false;
                boolean flag3 = false;
                for (Object2IntMap.Entry enchantment1 : map1.entrySet()) {
                    int j2;
                    if (enchantment1 == null) continue;
                    Holder holder = (Holder)enchantment1.getKey();
                    int enchantmentValue = map.getLevel(holder);
                    j2 = enchantmentValue == (j2 = enchantment1.getIntValue()) ? j2 + 1 : Math.max(j2, enchantmentValue);
                    boolean flag1 = inputFirst.supportsEnchantment(holder);
                    for (Holder enchantment : map.keySet()) {
                        if (enchantment.equals((Object)enchantment1) || Enchantment.areCompatible((Holder)holder, (Holder)enchantment)) continue;
                        flag1 = false;
                        ++i;
                    }
                    if (!flag1) {
                        flag3 = true;
                        continue;
                    }
                    flag2 = true;
                    if (!EnchantmentApplicatorConfig.ignoreEnchantMaxLevels && j2 > ((Enchantment)holder.value()).getMaxLevel()) {
                        j2 = ((Enchantment)holder.value()).getMaxLevel();
                    }
                    map.set(holder, j2);
                    int enchantmentRarity = ((Enchantment)holder.value()).getAnvilCost();
                    if (addEnchantment) {
                        enchantmentRarity = Math.max(1, enchantmentRarity / 2);
                    }
                    i += enchantmentRarity * j2;
                    if (inputFirst.getCount() <= 1) continue;
                    i = 40;
                }
                if (flag3 && !flag2) {
                    return Pair.of((Object)ItemStack.EMPTY, (Object)0);
                }
            }
        }
        if (addEnchantment && !inputFirstCopy.isBookEnchantable(inputSecond)) {
            inputFirstCopy = ItemStack.EMPTY;
        }
        maximumCost = j + i;
        if (i <= 0) {
            inputFirstCopy = ItemStack.EMPTY;
        }
        if (!inputFirstCopy.isEmpty()) {
            int repairCost = (Integer)inputFirstCopy.get(DataComponents.REPAIR_COST);
            if (!inputSecond.isEmpty() && repairCost < (Integer)inputSecond.get(DataComponents.REPAIR_COST)) {
                repairCost = (Integer)inputSecond.get(DataComponents.REPAIR_COST);
            }
            if (k != i || k == 0) {
                repairCost = AnvilMenu.calculateIncreasedRepairCost((int)repairCost);
            }
            inputFirstCopy.set(DataComponents.REPAIR_COST, (Object)repairCost);
            EnchantmentHelper.setEnchantments((ItemStack)inputFirstCopy, (ItemEnchantments)map.toImmutable());
        }
        return Pair.of((Object)inputFirstCopy, (Object)maximumCost);
    }
}

