/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator.mycelial;

import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.plugin.jei.generator.MycelialGeneratorRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class FireworkGeneratorType
implements IMycelialGeneratorType {
    @Override
    public String getName() {
        return "rocket";
    }

    @Override
    public IMycelialGeneratorType.Input[] getInputs() {
        return new IMycelialGeneratorType.Input[]{IMycelialGeneratorType.Input.SLOT};
    }

    public static FireworkExplosion.Shape get(int indexIn) {
        return indexIn >= 0 && indexIn < FireworkExplosion.Shape.values().length ? FireworkExplosion.Shape.values()[indexIn] : FireworkExplosion.Shape.SMALL_BALL;
    }

    @Override
    public List<Predicate<FluidStack>> getTankInputPredicates() {
        return new ArrayList<Predicate<FluidStack>>();
    }

    @Override
    public boolean canStart(INBTSerializable<CompoundTag>[] inputs) {
        return inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).getCount() > 0;
    }

    @Override
    public Pair<Integer, Integer> getTimeAndPowerGeneration(INBTSerializable<CompoundTag>[] inputs) {
        if (inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).getCount() > 0) {
            ItemStack stack = ((SidedInventoryComponent)inputs[0]).getStackInSlot(0);
            Pair<Integer, Integer> power = this.calculate(stack);
            stack.shrink(1);
            return power;
        }
        return Pair.of((Object)0, (Object)80);
    }

    @Override
    public DyeColor[] getInputColors() {
        return new DyeColor[]{DyeColor.RED};
    }

    @Override
    public Item getDisplay() {
        return Items.FIREWORK_ROCKET;
    }

    @Override
    public int getSlotSize() {
        return 64;
    }

    @Override
    public List<BiPredicate<ItemStack, Integer>> getSlotInputPredicates() {
        return Arrays.asList((stack, slot) -> stack.getItem() instanceof FireworkRocketItem && stack.has(DataComponents.FIREWORKS));
    }

    @Override
    public List<MycelialGeneratorRecipe> getRecipes(RegistryAccess registryAccess) {
        ArrayList<MycelialGeneratorRecipe> recipes = new ArrayList<MycelialGeneratorRecipe>();
        for (Item item : new Item[]{Items.FIREWORK_ROCKET}) {
            for (int flight = 1; flight < 4; ++flight) {
                ItemStack stack = new ItemStack((ItemLike)item);
                Fireworks fireworks = new Fireworks(flight, new ArrayList());
                stack.set(DataComponents.FIREWORKS, (Object)fireworks);
                Pair<Integer, Integer> power = this.calculate(stack);
                recipes.add(new MycelialGeneratorRecipe(Collections.singletonList(Collections.singletonList(Ingredient.of((ItemStack[])new ItemStack[]{stack}))), new ArrayList<List<FluidStack>>(), (Integer)power.getLeft(), (Integer)power.getRight()));
            }
        }
        return recipes;
    }

    private Pair<Integer, Integer> calculate(ItemStack stack) {
        Fireworks fireworksData;
        if (stack.getItem() instanceof FireworkRocketItem && stack.has(DataComponents.FIREWORKS) && (fireworksData = (Fireworks)stack.get(DataComponents.FIREWORKS)) != null) {
            int flight = fireworksData.flightDuration();
            double power = 1.0;
            List explosions = fireworksData.explosions();
            if (!explosions.isEmpty()) {
                for (FireworkExplosion explosion : explosions) {
                    FireworkExplosion.Shape shape = explosion.shape();
                    power *= this.getShapeModifier(shape);
                    IntList colors = explosion.colors();
                    power *= 1.0 + (double)colors.size() / 100.0;
                    IntList fadeColors = explosion.fadeColors();
                    power *= 1.0 + (double)fadeColors.size() / 90.0;
                    if (explosion.hasTrail()) {
                        power *= 1.6;
                    }
                    if (!explosion.hasTwinkle()) continue;
                    power *= 1.4;
                }
            }
            return Pair.of((Object)((int)(80.0 * power)), (Object)(60 * flight));
        }
        return Pair.of((Object)0, (Object)0);
    }

    private double getShapeModifier(FireworkExplosion.Shape shape) {
        switch (shape) {
            case STAR: {
                return 1.2;
            }
            case BURST: {
                return 1.05;
            }
            case CREEPER: {
                return 1.5;
            }
            case LARGE_BALL: {
                return 1.1;
            }
        }
        return 1.01;
    }

    @Override
    public ShapedRecipeBuilder addIngredients(ShapedRecipeBuilder recipeBuilder) {
        recipeBuilder = recipeBuilder.define(Character.valueOf('B'), (ItemLike)Items.GUNPOWDER).define(Character.valueOf('C'), (ItemLike)Items.PAPER).define(Character.valueOf('M'), IndustrialTags.Items.MACHINE_FRAME_ADVANCED);
        return recipeBuilder;
    }

    @Override
    public void onTick(Level world, BlockPos pos) {
        AABB area = new AABB((double)(pos.getX() - 3), (double)(pos.getY() - 3), (double)(pos.getZ() - 3), (double)(pos.getX() + 3), (double)(pos.getY() + 3), (double)(pos.getZ() + 3));
        for (LivingEntity livingEntity : world.getEntitiesOfClass(LivingEntity.class, area)) {
            livingEntity.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 10, 2));
        }
    }
}

