/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.agriculturehusbandry.MobCrusherConfig;
import com.buuz135.industrial.item.addon.RangeAddonItem;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.item.AugmentWrapper;
import com.hrznstudio.titanium.util.LangUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class MobCrusherTile
extends IndustrialAreaWorkingTile<MobCrusherTile> {
    private final Method DROP_CUSTOM_DEATH_LOOT = ObfuscationReflectionHelper.findMethod(Mob.class, (String)"dropCustomDeathLoot", (Class[])new Class[]{ServerLevel.class, DamageSource.class, Boolean.TYPE});
    @Save
    private SidedInventoryComponent<MobCrusherTile> output;
    @Save
    private SidedFluidTankComponent<MobCrusherTile> tank;
    @Save
    private boolean dropXP;
    private ButtonComponent buttonComponent;

    public MobCrusherTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleAgricultureHusbandry.MOB_CRUSHER, RangeManager.RangeType.BEHIND, true, MobCrusherConfig.powerPerOperation, blockPos, blockState);
        if (!this.DROP_CUSTOM_DEATH_LOOT.isAccessible()) {
            this.DROP_CUSTOM_DEATH_LOOT.setAccessible(true);
        }
        this.dropXP = true;
        this.tank = (SidedFluidTankComponent)new SidedFluidTankComponent("essence", MobCrusherConfig.tankSize, 43, 20, 0).setColor(DyeColor.LIME).setTankAction(FluidTankComponent.Action.DRAIN).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().is(IndustrialTags.Fluids.EXPERIENCE));
        this.addTank(this.tank);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 64, 22, 18, 1).setColor(DyeColor.ORANGE).setRange(6, 3).setInputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.output);
        this.buttonComponent = new ButtonComponent(100, 84, 14, 14){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new StateButtonAddon(this, new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[]{String.valueOf(ChatFormatting.GOLD) + LangUtil.getString((String)"tooltip.industrialforegoing.mob_crusher.produce", (Object[])new Object[0]), "tooltip.industrialforegoing.mob_crusher.produce_extra"}), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[]{String.valueOf(ChatFormatting.GOLD) + LangUtil.getString((String)"tooltip.industrialforegoing.mob_crusher.consume", (Object[])new Object[0]), "tooltip.industrialforegoing.mob_crusher.consume_extra_1", "tooltip.industrialforegoing.mob_crusher.consume_extra_2"})}){

                    public int getState() {
                        return MobCrusherTile.this.dropXP ? 0 : 1;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.dropXP = !this.dropXP;
            this.markForUpdate();
        });
        this.addButton(this.buttonComponent);
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        List mobs;
        if (this.hasEnergy(MobCrusherConfig.powerPerOperation) && (mobs = this.level.getEntitiesOfClass(Mob.class, this.getWorkingArea().bounds()).stream().filter(mobEntity -> !(mobEntity instanceof Animal && mobEntity.isBaby() || mobEntity.isInvulnerable() || mobEntity instanceof WitherBoss && ((WitherBoss)mobEntity).getInvulnerableTicks() > 0)).filter(LivingEntity::isAlive).collect(Collectors.toList())).size() > 0) {
            Mob entity = (Mob)mobs.get(0);
            FakePlayer player = IndustrialForegoing.getFakePlayer(this.level, this.getBlockPos(), this.getUuid());
            if (entity.getType().is(IndustrialTags.EntityTypes.MOB_CRUSHER_INSTANT_KILL_BLACKLIST)) {
                return this.damage(entity, player);
            }
            return this.instantKill(entity, player);
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    private IndustrialWorkingTile.WorkAction instantKill(Mob entity, FakePlayer player) {
        int experience = entity.getExperienceReward((ServerLevel)this.level, (Entity)player);
        int looting = 0;
        if (!this.dropXP) {
            looting = this.level.random.nextInt(4);
            ItemStack sword = new ItemStack((ItemLike)Items.DIAMOND_SWORD);
            ItemEnchantments.Mutable enchants = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
            enchants.set(this.level.registryAccess().holderOrThrow(Enchantments.LOOTING), looting);
            EnchantmentHelper.setEnchantments((ItemStack)sword, (ItemEnchantments)enchants.toImmutable());
            player.setItemInHand(InteractionHand.MAIN_HAND, sword);
        }
        DamageSource source = player.damageSources().playerAttack((Player)player);
        LootTable table = this.level.getServer().reloadableRegistries().getLootTable(entity.getLootTable());
        LootParams.Builder context = new LootParams.Builder((ServerLevel)this.level).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)source).withParameter(LootContextParams.ORIGIN, (Object)new Vec3((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ())).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)player).withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)player).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)player);
        table.getRandomItems(context.create(LootContextParamSets.ENTITY)).forEach(stack -> ItemHandlerHelper.insertItem(this.output, (ItemStack)stack, (boolean)false));
        ArrayList extra = new ArrayList();
        try {
            if (entity.captureDrops() == null) {
                entity.captureDrops(new ArrayList());
            }
            this.DROP_CUSTOM_DEATH_LOOT.invoke((Object)entity, (ServerLevel)this.level, source, true);
            if (entity.captureDrops() != null) {
                extra.addAll(entity.captureDrops());
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        CommonHooks.onLivingDrops((LivingEntity)entity, (DamageSource)source, extra, (boolean)true);
        extra.forEach(itemEntity -> {
            ItemHandlerHelper.insertItem(this.output, (ItemStack)itemEntity.getItem(), (boolean)false);
            itemEntity.remove(Entity.RemovalReason.KILLED);
        });
        if (this.dropXP) {
            this.tank.fillForced(new FluidStack((Fluid)ModuleCore.ESSENCE.getSourceFluid().get(), experience * 20), IFluidHandler.FluidAction.EXECUTE);
        }
        entity.setHealth(0.0f);
        entity.remove(Entity.RemovalReason.KILLED);
        player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        return new IndustrialWorkingTile.WorkAction(this, 0.1f, MobCrusherConfig.powerPerOperation);
    }

    private IndustrialWorkingTile.WorkAction damage(Mob entity, FakePlayer player) {
        entity.hurt(entity.damageSources().playerAttack((Player)player), (float)MobCrusherConfig.attackDamage);
        return new IndustrialWorkingTile.WorkAction(this, 0.1f, MobCrusherConfig.powerPerOperation);
    }

    @Override
    public VoxelShape getWorkingArea() {
        return new RangeManager(this, this.worldPosition, this.getFacingDirection(), RangeManager.RangeType.BEHIND){

            @Override
            public AABB getBox() {
                return super.getBox().expandTowards(0.0, 2.0, 0.0);
            }
        }.get(this.hasAugmentInstalled(RangeAddonItem.RANGE) ? (int)AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(RangeAddonItem.RANGE).get(0)), (IAugmentType)RangeAddonItem.RANGE) + 1 : 0);
    }

    public MobCrusherTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<MobCrusherTile> createEnergyStorage() {
        return new EnergyStorageComponent(MobCrusherConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return MobCrusherConfig.maxProgress;
    }

    @Override
    public void saveSettings(Player player, CompoundTag tag) {
        tag.putBoolean("MC_drops", this.dropXP);
        super.saveSettings(player, tag);
    }

    @Override
    public void loadSettings(Player player, CompoundTag tag) {
        if (tag.contains("MC_drops")) {
            this.dropXP = tag.getBoolean("MC_drops");
        }
        super.loadSettings(player, tag);
    }
}

