/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.improvedsignediting_common_neoforge.events;

import com.natamus.collective_common_neoforge.functions.ScreenFunctions;
import com.natamus.improvedsignediting_common_neoforge.config.ConfigHandler;
import com.natamus.improvedsignediting_common_neoforge.data.Constants;
import com.natamus.improvedsignediting_common_neoforge.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractSignEditScreen;

public class SignEditEvent {
    public static void onClientTick(Minecraft mc) {
        Screen screen = mc.screen;
        if (!(screen instanceof AbstractSignEditScreen)) {
            return;
        }
        if (!ConfigHandler.enableImprovedEditing || !Util.improvedEditingEnabled) {
            return;
        }
        AbstractSignEditScreen signEditScreen = (AbstractSignEditScreen)screen;
        String[] messages = ScreenFunctions.getSignMessagesFromScreen((AbstractSignEditScreen)signEditScreen);
        ArrayList<String> messageList = new ArrayList<String>(Arrays.asList(messages));
        if (Util.messagesAreEqual(messageList)) {
            return;
        }
        Util.preMessages = messageList;
        int signLine = ScreenFunctions.getSignLineFromScreen((AbstractSignEditScreen)signEditScreen);
        String lineMessage = messages[signLine];
        int lineWidth = Constants.font.width(lineMessage);
        if (lineWidth == Util.preLineWidth) {
            return;
        }
        Util.startLine = Util.getStartLine(messageList);
        if (lineWidth >= Constants.getMaxSignWidth(screen) && lineWidth > Util.preLineWidth) {
            if (signLine == 3) {
                return;
            }
            if (!messages[signLine + 1].isEmpty()) {
                return;
            }
            boolean endsWithSpace = lineMessage.endsWith(" ");
            String strippedLineMessage = lineMessage.strip();
            String[] lineMessageSpl = strippedLineMessage.split(" ");
            if (lineMessageSpl.length <= 1) {
                Util.preLineWidth = lineWidth;
                return;
            }
            String lineMessageWithoutLastWord = strippedLineMessage.substring(0, strippedLineMessage.lastIndexOf(" "));
            Object lineMessageLastWord = lineMessageSpl[lineMessageSpl.length - 1];
            if (endsWithSpace) {
                lineMessageLastWord = (String)lineMessageLastWord + " ";
            }
            ScreenFunctions.signSetMessage((AbstractSignEditScreen)signEditScreen, (String)lineMessageWithoutLastWord, (int)signLine, (boolean)false);
            ScreenFunctions.signSetMessage((AbstractSignEditScreen)signEditScreen, (String)lineMessageLastWord, (int)(signLine + 1), (boolean)true);
            ScreenFunctions.getSignFieldFromScreen((AbstractSignEditScreen)signEditScreen).setCursorToEnd();
            Util.preJumpLine = signLine;
            if (!Util.linesJumped.contains(signLine)) {
                Util.linesJumped.add(signLine);
            }
            Util.preLineWidth = Constants.font.width((String)lineMessageLastWord);
        } else if (Util.preJumpLine >= 0 && signLine > 0) {
            int lastLineWidth = Constants.font.width(messages[signLine - 1] + " ");
            if (lastLineWidth + lineWidth > Constants.getMaxSignWidth(screen) || lastLineWidth < 10 || signLine == Util.startLine) {
                Util.preLineWidth = lineWidth;
                return;
            }
            String newContent = messages[signLine - 1] + " " + messages[signLine].strip();
            ScreenFunctions.signSetMessage((AbstractSignEditScreen)signEditScreen, (String)newContent, (int)(signLine - 1), (boolean)true);
            ScreenFunctions.signSetMessage((AbstractSignEditScreen)signEditScreen, (String)"", (int)signLine, (boolean)false);
            ScreenFunctions.getSignFieldFromScreen((AbstractSignEditScreen)signEditScreen).setCursorToEnd();
            if (Util.linesJumped.contains(signLine - 1)) {
                Util.preJumpLine = signLine - 1;
            } else {
                signLine = -1;
            }
            Util.preLineWidth = lineWidth;
        }
    }
}

