/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.hyperbox.blocks;

import java.util.Optional;
import net.commoble.hyperbox.Hyperbox;
import net.commoble.hyperbox.blocks.ApertureBlockEntity;
import net.commoble.hyperbox.blocks.HyperboxBlock;
import net.commoble.hyperbox.blocks.HyperboxBlockEntity;
import net.commoble.hyperbox.dimension.DelayedTeleportData;
import net.commoble.hyperbox.dimension.HyperboxSaveData;
import net.commoble.hyperbox.dimension.SpawnPointHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ApertureBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;

    public ApertureBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return Hyperbox.INSTANCE.apertureBlockEntityType.get().create(pos, state);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (level instanceof ServerLevel) {
                BlockPos parentPos;
                ServerLevel serverLevel = (ServerLevel)level;
                MinecraftServer server = serverPlayer.server;
                HyperboxSaveData data = HyperboxSaveData.getOrCreate(serverLevel);
                ResourceKey<Level> parentKey = data.getParentWorld();
                BlockPos targetPos = parentPos = data.getParentPos();
                ServerLevel destinationLevel = server.getLevel(parentKey);
                if (destinationLevel == null) {
                    destinationLevel = server.getLevel(Level.OVERWORLD);
                }
                Direction apertureFacing = (Direction)state.getValue((Property)FACING);
                BlockState parentState = destinationLevel.getBlockState(parentPos);
                Block parentBlock = parentState.getBlock();
                if (parentBlock instanceof HyperboxBlock) {
                    HyperboxBlock hyperboxBlock = (HyperboxBlock)parentBlock;
                    Direction hyperboxFacing = hyperboxBlock.getCurrentFacing(parentState, apertureFacing.getOpposite());
                    targetPos = parentPos.relative(hyperboxFacing);
                    if (destinationLevel.getBlockState(targetPos).getDestroySpeed((BlockGetter)destinationLevel, targetPos) < 0.0f) {
                        targetPos = parentPos;
                    }
                    targetPos = SpawnPointHelper.getBestSpawnPosition((BlockGetter)destinationLevel, targetPos, targetPos.offset(-3, -3, -3), targetPos.offset(3, 3, 3));
                }
                DelayedTeleportData.getOrCreate(serverPlayer.serverLevel()).schedulePlayerTeleport((Player)serverPlayer, (ResourceKey<Level>)destinationLevel.dimension(), Vec3.atCenterOf((Vec3i)targetPos));
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Deprecated
    public void neighborChanged(BlockState thisState, Level level, BlockPos thisPos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
        this.onNeighborUpdated(thisState, (BlockGetter)level, thisPos, level.getBlockState(fromPos), fromPos);
        super.neighborChanged(thisState, level, thisPos, fromBlock, fromPos, isMoving);
    }

    public void onNeighborChange(BlockState thisState, LevelReader level, BlockPos thisPos, BlockPos neighborPos) {
        this.onNeighborUpdated(thisState, (BlockGetter)level, thisPos, level.getBlockState(neighborPos), neighborPos);
        super.onNeighborChange(thisState, level, thisPos, neighborPos);
    }

    protected void onNeighborUpdated(BlockState thisState, BlockGetter level, BlockPos thisPos, BlockState neighborState, BlockPos neighborPos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Direction directionToNeighbor = (Direction)thisState.getValue((Property)FACING);
            int weakPower = neighborState.getSignal(level, neighborPos, directionToNeighbor);
            int strongPower = neighborState.getDirectSignal(level, neighborPos, directionToNeighbor);
            ApertureBlock.getLinkedHyperbox(serverLevel, thisPos).ifPresent(hyperbox -> {
                hyperbox.updatePower(weakPower, strongPower, directionToNeighbor.getOpposite());
                hyperbox.setChanged();
            });
        }
    }

    @Deprecated
    public boolean isSignalSource(BlockState state) {
        return true;
    }

    @Deprecated
    public int getSignal(BlockState blockState, BlockGetter level, BlockPos pos, Direction sideOfAdjacentBlock) {
        int n;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ApertureBlockEntity) {
            ApertureBlockEntity aperture = (ApertureBlockEntity)blockEntity;
            n = aperture.getPower(false);
        } else {
            n = 0;
        }
        return n;
    }

    @Deprecated
    public int getDirectSignal(BlockState blockState, BlockGetter level, BlockPos pos, Direction sideOfAdjacentBlock) {
        int n;
        BlockEntity blockEntity;
        if (sideOfAdjacentBlock.getOpposite() == blockState.getValue((Property)FACING) && (blockEntity = level.getBlockEntity(pos)) instanceof ApertureBlockEntity) {
            ApertureBlockEntity aperture = (ApertureBlockEntity)blockEntity;
            n = aperture.getPower(true);
        } else {
            n = 0;
        }
        return n;
    }

    public static Optional<HyperboxBlockEntity> getLinkedHyperbox(ServerLevel level, BlockPos thisPos) {
        Optional<HyperboxBlockEntity> optional;
        MinecraftServer server = level.getServer();
        HyperboxSaveData data = HyperboxSaveData.getOrCreate(level);
        BlockPos parentPos = data.getParentPos();
        ResourceKey<Level> parentLevelKey = data.getParentWorld();
        ServerLevel parentLevel = server.getLevel(parentLevelKey);
        BlockEntity blockEntity = parentLevel.getBlockEntity(parentPos);
        if (blockEntity instanceof HyperboxBlockEntity) {
            HyperboxBlockEntity hyperbox = (HyperboxBlockEntity)blockEntity;
            optional = Optional.of(hyperbox);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }
}

