/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.harvest_with_ease.api;

import it.crystalnest.cobweb.api.block.BlockUtils;
import it.crystalnest.harvest_with_ease.config.ModConfig;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.PitcherCropBlock;
import net.minecraft.world.level.block.TorchflowerCropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.ApiStatus;

public final class HarvestUtils {
    public static final TagKey<Block> BLACKLIST = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"harvest_with_ease", (String)"blacklist"));

    private HarvestUtils() {
    }

    public static boolean isCrop(Block block) {
        return !(block instanceof TorchflowerCropBlock) && (block instanceof CropBlock || block instanceof NetherWartBlock || block instanceof CocoaBlock || block instanceof PitcherCropBlock || ModConfig.getCrops().contains(BlockUtils.getStringKey((Block)block)));
    }

    public static boolean isAllowed(BlockState block) {
        return ModConfig.getBlacklist().stream().noneMatch(id -> id.equalsIgnoreCase(BlockUtils.getStringKey((Block)block.getBlock()))) && !block.is(BLACKLIST);
    }

    public static boolean hasEnoughHunger(Player player) {
        FoodData foodData;
        FoodData foodData2;
        return player.level().getDifficulty() == Difficulty.PEACEFUL || ModConfig.getExhaustionMultiplier().compareTo(BigDecimal.ZERO) == 0 || (foodData2 = player.getFoodData()) instanceof FoodData && (double)((float)(foodData = foodData2).getFoodLevel() + foodData.getSaturationLevel()) - Math.floor(foodData.exhaustionLevel / 4.0f) >= 0.0;
    }

    public static IntegerProperty getAge(BlockState blockState) throws NullPointerException, NoSuchElementException, ClassCastException {
        return (IntegerProperty)blockState.getProperties().stream().filter(property -> "age".equals(property.getName())).findFirst().orElseThrow();
    }

    public static boolean isMature(BlockState blockState, IntegerProperty age) {
        return blockState.getOptionalValue((Property)age).orElse(0) >= (Integer)Collections.max(age.getPossibleValues());
    }

    public static boolean isMature(BlockState blockState) throws NullPointerException, NoSuchElementException, ClassCastException {
        return HarvestUtils.isMature(blockState, HarvestUtils.getAge(blockState));
    }

    public static boolean isTallCrop(BlockGetter level, BlockState blockState, BlockPos blockPos) {
        return blockState.is(BlockTags.CROPS) && level.getBlockState(blockPos.below()).is(blockState.getBlock()) || level.getBlockState(blockPos.above()).is(blockState.getBlock());
    }

    public static boolean isTierForMultiHarvest(TieredItem tool) {
        return ModConfig.getTiers().stream().anyMatch(tier -> HarvestUtils.isSameTier(ResourceLocation.parse((String)tier), tool.getTier().getIncorrectBlocksForDrops().location()));
    }

    public static int getTierLevel(TieredItem tool) {
        return HarvestUtils.getTierLevel(tool.getTier().getIncorrectBlocksForDrops().location());
    }

    @ApiStatus.Internal
    public static int getTierLevel(ResourceLocation tier) {
        List<? extends String> tiers = ModConfig.getTiers();
        for (int i = 0; i < tiers.size(); ++i) {
            if (!HarvestUtils.isSameTier(ResourceLocation.parse((String)tiers.get(i)), tier)) continue;
            return i;
        }
        return 0;
    }

    private static boolean isSameTier(ResourceLocation tier1, ResourceLocation tier2) {
        return tier1.getNamespace().equalsIgnoreCase(tier2.getNamespace()) && (tier1.getPath().equalsIgnoreCase(tier2.getPath()) || ("incorrect_for_" + tier1.getPath() + "_tool").equalsIgnoreCase(tier2.getPath()) || ("incorrect_for_" + tier1.getPath() + "en_tool").equalsIgnoreCase(tier2.getPath()));
    }
}

