/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.guieffecttimer_common_forge.util;

import com.natamus.guieffecttimer_common_forge.config.ConfigHandler;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import org.jetbrains.annotations.NotNull;

public class Util {
    public static void addEffectTimer(GuiGraphics guiGraphics, MobEffectInstance mobEffectInstance, int k, int l) {
        String timeText = Util.getTimeText(mobEffectInstance);
        Font font = Minecraft.getInstance().font;
        float scale = 0.7f;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(scale, scale, 1.0f);
        guiGraphics.pose().translate(-0.5f / scale, 0.0f, 0.0f);
        guiGraphics.drawString(font, (Component)Component.literal((String)timeText), (int)((float)(k + 13) / scale - (float)font.width(timeText) / 2.0f), (int)((float)(l + 16) / scale), new Color(ConfigHandler.timerColourRGB_R, ConfigHandler.timerColourRGB_G, ConfigHandler.timerColourRGB_B).getRGB(), true);
        guiGraphics.pose().popPose();
    }

    @NotNull
    private static String getTimeText(MobEffectInstance mobEffectInstance) {
        int ticks = mobEffectInstance.getDuration();
        if (ticks < 0) {
            return "\u221e";
        }
        double seconds = (double)ticks / 20.0;
        if (seconds < 60.0) {
            return String.format("%.0fs", seconds);
        }
        if (seconds < 3600.0) {
            return String.format("%dm", (int)(seconds / 60.0));
        }
        if (seconds < 86400.0) {
            return String.format("%dh", (int)(seconds / 3600.0));
        }
        return String.format("%dd", (int)(seconds / 86400.0));
    }
}

