/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark.commonmark;

import guideme.libs.micromark.Assert;
import guideme.libs.micromark.CharUtil;
import guideme.libs.micromark.Construct;
import guideme.libs.micromark.State;
import guideme.libs.micromark.Token;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;
import guideme.libs.micromark.factory.FactorySpace;
import java.util.List;

public final class SetextUnderline {
    public static final Construct setextUnderline = new Construct();

    private SetextUnderline() {
    }

    private static List<Tokenizer.Event> resolveToSetextUnderline(List<Tokenizer.Event> events, TokenizeContext context) {
        int index = events.size();
        Integer content = null;
        Integer text = null;
        Integer definition = null;
        while (index-- > 0) {
            if (events.get(index).isEnter()) {
                if (events.get((int)index).token().type.equals("content")) {
                    content = index;
                    break;
                }
                if (!events.get((int)index).token().type.equals("paragraph")) continue;
                text = index;
                continue;
            }
            if (events.get((int)index).token().type.equals("content")) {
                events.remove(index);
            }
            if (definition != null || !events.get((int)index).token().type.equals("definition")) continue;
            definition = index;
        }
        Assert.check(text != null, "expected a `text` index to be found");
        Assert.check(content != null, "expected a `text` index to be found");
        Token heading = new Token();
        heading.type = "setextHeading";
        heading.start = events.get((int)text.intValue()).token().start;
        heading.end = events.get((int)(events.size() - 1)).token().end;
        events.get((int)text.intValue()).token().type = "setextHeadingText";
        if (definition != null) {
            events.add(text, Tokenizer.Event.enter(heading, context));
            events.add(definition + 1, Tokenizer.Event.exit(events.get(content).token(), context));
            events.get((int)content.intValue()).token().end = events.get((int)definition.intValue()).token().end;
        } else {
            Tokenizer.Event prevEvent = events.get(content);
            events.set(content, new Tokenizer.Event(prevEvent.type(), heading, prevEvent.context()));
        }
        events.add(Tokenizer.Event.exit(heading, context));
        return events;
    }

    static {
        SetextUnderline.setextUnderline.name = "setextUnderline";
        SetextUnderline.setextUnderline.tokenize = (context, effects, ok, nok) -> new StateMachine(context, effects, ok, nok)::start;
        SetextUnderline.setextUnderline.resolveTo = SetextUnderline::resolveToSetextUnderline;
    }

    private static class StateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;
        int marker;
        boolean paragraph;

        public StateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
            int index = context.getEvents().size();
            while (index-- > 0) {
                if (context.getEvents().get((int)index).token().type.equals("lineEnding") || context.getEvents().get((int)index).token().type.equals("linePrefix") || context.getEvents().get((int)index).token().type.equals("content")) continue;
                this.paragraph = context.getEvents().get((int)index).token().type.equals("paragraph");
                break;
            }
        }

        private State start(int code) {
            Assert.check(code == 45 || code == 61, "expected `=` or `-`");
            if (!this.context.isOnLazyLine() && (this.context.isInterrupt() || this.paragraph)) {
                this.effects.enter("setextHeadingLine");
                this.effects.enter("setextHeadingLineSequence");
                this.marker = code;
                return this.closingSequence(code);
            }
            return this.nok.step(code);
        }

        private State closingSequence(int code) {
            if (code == this.marker) {
                this.effects.consume(code);
                return this::closingSequence;
            }
            this.effects.exit("setextHeadingLineSequence");
            return FactorySpace.create(this.effects, this::closingSequenceEnd, "lineSuffix").step(code);
        }

        private State closingSequenceEnd(int code) {
            if (code == Integer.MIN_VALUE || CharUtil.markdownLineEnding(code)) {
                this.effects.exit("setextHeadingLine");
                return this.ok.step(code);
            }
            return this.nok.step(code);
        }
    }
}

