/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.fst;

import guideme.internal.shaded.lucene.store.DataOutput;
import guideme.internal.shaded.lucene.store.IndexInput;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;
import guideme.internal.shaded.lucene.util.fst.FST;
import guideme.internal.shaded.lucene.util.fst.FSTReader;
import guideme.internal.shaded.lucene.util.fst.ReverseRandomAccessReader;
import java.io.IOException;

public final class OffHeapFSTStore
implements FSTReader {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(OffHeapFSTStore.class);
    private final IndexInput in;
    private final long offset;
    private final long numBytes;

    public OffHeapFSTStore(IndexInput in, long offset, FST.FSTMetadata<?> metadata) {
        this.in = in;
        this.offset = offset;
        this.numBytes = metadata.numBytes;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED;
    }

    public long size() {
        return this.numBytes;
    }

    @Override
    public FST.BytesReader getReverseBytesReader() {
        try {
            return new ReverseRandomAccessReader(this.in.randomAccessSlice(this.offset, this.numBytes));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        throw new UnsupportedOperationException("writeToOutput operation is not supported for OffHeapFSTStore");
    }
}

