/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.search.BlockMaxConjunctionBulkScorer;
import guideme.internal.shaded.lucene.search.BlockMaxConjunctionScorer;
import guideme.internal.shaded.lucene.search.BooleanClause;
import guideme.internal.shaded.lucene.search.BooleanScorer;
import guideme.internal.shaded.lucene.search.BulkScorer;
import guideme.internal.shaded.lucene.search.ConjunctionBulkScorer;
import guideme.internal.shaded.lucene.search.ConjunctionScorer;
import guideme.internal.shaded.lucene.search.ConstantScoreScorer;
import guideme.internal.shaded.lucene.search.DisjunctionSumScorer;
import guideme.internal.shaded.lucene.search.FilterScorer;
import guideme.internal.shaded.lucene.search.LeafCollector;
import guideme.internal.shaded.lucene.search.MaxScoreBulkScorer;
import guideme.internal.shaded.lucene.search.ReqExclBulkScorer;
import guideme.internal.shaded.lucene.search.ReqExclScorer;
import guideme.internal.shaded.lucene.search.ReqOptSumScorer;
import guideme.internal.shaded.lucene.search.Scorable;
import guideme.internal.shaded.lucene.search.Score;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.Scorer;
import guideme.internal.shaded.lucene.search.ScorerSupplier;
import guideme.internal.shaded.lucene.search.ScorerUtil;
import guideme.internal.shaded.lucene.search.WANDScorer;
import guideme.internal.shaded.lucene.search.Weight;
import guideme.internal.shaded.lucene.util.Bits;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.stream.Stream;

final class BooleanScorerSupplier
extends ScorerSupplier {
    private final Map<BooleanClause.Occur, Collection<ScorerSupplier>> subs;
    private final ScoreMode scoreMode;
    private final int minShouldMatch;
    private final int maxDoc;
    private long cost = -1L;
    private boolean topLevelScoringClause;

    BooleanScorerSupplier(Weight weight, Map<BooleanClause.Occur, Collection<ScorerSupplier>> subs, ScoreMode scoreMode, int minShouldMatch, int maxDoc) {
        if (minShouldMatch < 0) {
            throw new IllegalArgumentException("minShouldMatch must be positive, but got: " + minShouldMatch);
        }
        if (minShouldMatch != 0 && minShouldMatch >= subs.get((Object)BooleanClause.Occur.SHOULD).size()) {
            throw new IllegalArgumentException("minShouldMatch must be strictly less than the number of SHOULD clauses");
        }
        if (!scoreMode.needsScores() && minShouldMatch == 0 && subs.get((Object)BooleanClause.Occur.SHOULD).size() > 0 && subs.get((Object)BooleanClause.Occur.MUST).size() + subs.get((Object)BooleanClause.Occur.FILTER).size() > 0) {
            throw new IllegalArgumentException("Cannot pass purely optional clauses if scores are not needed");
        }
        if (subs.get((Object)BooleanClause.Occur.SHOULD).size() + subs.get((Object)BooleanClause.Occur.MUST).size() + subs.get((Object)BooleanClause.Occur.FILTER).size() == 0) {
            throw new IllegalArgumentException("There should be at least one positive clause");
        }
        this.subs = subs;
        this.scoreMode = scoreMode;
        this.minShouldMatch = minShouldMatch;
        this.maxDoc = maxDoc;
    }

    private long computeCost() {
        OptionalLong minRequiredCost = Stream.concat(this.subs.get((Object)BooleanClause.Occur.MUST).stream(), this.subs.get((Object)BooleanClause.Occur.FILTER).stream()).mapToLong(ScorerSupplier::cost).min();
        if (minRequiredCost.isPresent() && this.minShouldMatch == 0) {
            return minRequiredCost.getAsLong();
        }
        Collection<ScorerSupplier> optionalScorers = this.subs.get((Object)BooleanClause.Occur.SHOULD);
        long shouldCost = ScorerUtil.costWithMinShouldMatch(optionalScorers.stream().mapToLong(ScorerSupplier::cost), optionalScorers.size(), this.minShouldMatch);
        return Math.min(minRequiredCost.orElse(Long.MAX_VALUE), shouldCost);
    }

    @Override
    public void setTopLevelScoringClause() throws IOException {
        this.topLevelScoringClause = true;
        if (this.subs.get((Object)BooleanClause.Occur.SHOULD).size() + this.subs.get((Object)BooleanClause.Occur.MUST).size() == 1) {
            for (ScorerSupplier ss : this.subs.get((Object)BooleanClause.Occur.SHOULD)) {
                ss.setTopLevelScoringClause();
            }
            for (ScorerSupplier ss : this.subs.get((Object)BooleanClause.Occur.MUST)) {
                ss.setTopLevelScoringClause();
            }
        }
    }

    @Override
    public long cost() {
        if (this.cost == -1L) {
            this.cost = this.computeCost();
        }
        return this.cost;
    }

    @Override
    public Scorer get(long leadCost) throws IOException {
        Scorer scorer = this.getInternal(leadCost);
        if (this.scoreMode == ScoreMode.TOP_SCORES && this.subs.get((Object)BooleanClause.Occur.SHOULD).isEmpty() && this.subs.get((Object)BooleanClause.Occur.MUST).isEmpty()) {
            return scorer.twoPhaseIterator() != null ? new ConstantScoreScorer(0.0f, this.scoreMode, scorer.twoPhaseIterator()) : new ConstantScoreScorer(0.0f, this.scoreMode, scorer.iterator());
        }
        return scorer;
    }

    private Scorer getInternal(long leadCost) throws IOException {
        leadCost = Math.min(leadCost, this.cost());
        if (this.subs.get((Object)BooleanClause.Occur.SHOULD).isEmpty()) {
            return this.excl(this.req(this.subs.get((Object)BooleanClause.Occur.FILTER), this.subs.get((Object)BooleanClause.Occur.MUST), leadCost, this.topLevelScoringClause), this.subs.get((Object)BooleanClause.Occur.MUST_NOT), leadCost);
        }
        if (this.subs.get((Object)BooleanClause.Occur.FILTER).isEmpty() && this.subs.get((Object)BooleanClause.Occur.MUST).isEmpty()) {
            return this.excl(this.opt(this.subs.get((Object)BooleanClause.Occur.SHOULD), this.minShouldMatch, this.scoreMode, leadCost, this.topLevelScoringClause), this.subs.get((Object)BooleanClause.Occur.MUST_NOT), leadCost);
        }
        if (this.minShouldMatch > 0) {
            Scorer req = this.excl(this.req(this.subs.get((Object)BooleanClause.Occur.FILTER), this.subs.get((Object)BooleanClause.Occur.MUST), leadCost, false), this.subs.get((Object)BooleanClause.Occur.MUST_NOT), leadCost);
            Scorer opt = this.opt(this.subs.get((Object)BooleanClause.Occur.SHOULD), this.minShouldMatch, this.scoreMode, leadCost, false);
            return new ConjunctionScorer(Arrays.asList(req, opt), Arrays.asList(req, opt));
        }
        assert (this.scoreMode.needsScores());
        return new ReqOptSumScorer(this.excl(this.req(this.subs.get((Object)BooleanClause.Occur.FILTER), this.subs.get((Object)BooleanClause.Occur.MUST), leadCost, false), this.subs.get((Object)BooleanClause.Occur.MUST_NOT), leadCost), this.opt(this.subs.get((Object)BooleanClause.Occur.SHOULD), this.minShouldMatch, this.scoreMode, leadCost, false), this.scoreMode);
    }

    @Override
    public BulkScorer bulkScorer() throws IOException {
        BulkScorer bulkScorer = this.booleanScorer();
        if (bulkScorer != null) {
            return bulkScorer;
        }
        return super.bulkScorer();
    }

    BulkScorer booleanScorer() throws IOException {
        BulkScorer positiveScorer;
        int numOptionalClauses = this.subs.get((Object)BooleanClause.Occur.SHOULD).size();
        int numMustClauses = this.subs.get((Object)BooleanClause.Occur.MUST).size();
        int numRequiredClauses = numMustClauses + this.subs.get((Object)BooleanClause.Occur.FILTER).size();
        if (numRequiredClauses == 0) {
            long costThreshold = this.minShouldMatch <= 1 ? -1L : (long)(this.maxDoc / 3);
            if (this.cost() < costThreshold) {
                return null;
            }
            positiveScorer = this.optionalBulkScorer();
        } else if (numMustClauses == 0 && numOptionalClauses > 1 && this.minShouldMatch >= 1) {
            positiveScorer = this.filteredOptionalBulkScorer();
        } else if (numRequiredClauses > 0 && numOptionalClauses == 0 && this.minShouldMatch == 0) {
            positiveScorer = this.requiredBulkScorer();
        } else {
            return null;
        }
        if (positiveScorer == null) {
            return null;
        }
        long positiveScorerCost = positiveScorer.cost();
        ArrayList<Scorer> prohibited = new ArrayList<Scorer>();
        for (ScorerSupplier ss : this.subs.get((Object)BooleanClause.Occur.MUST_NOT)) {
            prohibited.add(ss.get(positiveScorerCost));
        }
        if (prohibited.isEmpty()) {
            return positiveScorer;
        }
        Scorer prohibitedScorer = prohibited.size() == 1 ? (Scorer)prohibited.get(0) : new DisjunctionSumScorer(prohibited, ScoreMode.COMPLETE_NO_SCORES);
        return new ReqExclBulkScorer(positiveScorer, prohibitedScorer);
    }

    static BulkScorer disableScoring(final BulkScorer scorer) {
        Objects.requireNonNull(scorer);
        return new BulkScorer(){

            @Override
            public int score(final LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
                LeafCollector noScoreCollector = new LeafCollector(){
                    Score fake = new Score();

                    @Override
                    public void setScorer(Scorable scorer) throws IOException {
                        collector.setScorer(this.fake);
                    }

                    @Override
                    public void collect(int doc) throws IOException {
                        collector.collect(doc);
                    }
                };
                return scorer.score(noScoreCollector, acceptDocs, min, max);
            }

            @Override
            public long cost() {
                return scorer.cost();
            }
        };
    }

    BulkScorer optionalBulkScorer() throws IOException {
        if (this.subs.get((Object)BooleanClause.Occur.SHOULD).size() == 0) {
            return null;
        }
        if (this.subs.get((Object)BooleanClause.Occur.SHOULD).size() == 1 && this.minShouldMatch <= 1) {
            return this.subs.get((Object)BooleanClause.Occur.SHOULD).iterator().next().bulkScorer();
        }
        if (this.scoreMode == ScoreMode.TOP_SCORES && this.minShouldMatch <= 1) {
            ArrayList<Scorer> optionalScorers = new ArrayList<Scorer>();
            for (ScorerSupplier ss : this.subs.get((Object)BooleanClause.Occur.SHOULD)) {
                optionalScorers.add(ss.get(Long.MAX_VALUE));
            }
            return new MaxScoreBulkScorer(this.maxDoc, optionalScorers, null);
        }
        ArrayList<Scorer> optional = new ArrayList<Scorer>();
        for (ScorerSupplier ss : this.subs.get((Object)BooleanClause.Occur.SHOULD)) {
            optional.add(ss.get(Long.MAX_VALUE));
        }
        return new BooleanScorer(optional, Math.max(1, this.minShouldMatch), this.scoreMode.needsScores());
    }

    /*
     * WARNING - void declaration
     */
    BulkScorer filteredOptionalBulkScorer() throws IOException {
        void var5_8;
        if (!this.subs.get((Object)BooleanClause.Occur.MUST).isEmpty() || this.subs.get((Object)BooleanClause.Occur.FILTER).isEmpty() || this.scoreMode != ScoreMode.TOP_SCORES || this.subs.get((Object)BooleanClause.Occur.SHOULD).size() <= 1 || this.minShouldMatch > 1) {
            return null;
        }
        long cost = this.cost();
        ArrayList<Scorer> optionalScorers = new ArrayList<Scorer>();
        for (ScorerSupplier scorerSupplier : this.subs.get((Object)BooleanClause.Occur.SHOULD)) {
            optionalScorers.add(scorerSupplier.get(cost));
        }
        ArrayList<Scorer> filters = new ArrayList<Scorer>();
        for (ScorerSupplier ss : this.subs.get((Object)BooleanClause.Occur.FILTER)) {
            filters.add(ss.get(cost));
        }
        if (filters.size() == 1) {
            Scorer scorer = (Scorer)filters.iterator().next();
        } else {
            ConjunctionScorer conjunctionScorer = new ConjunctionScorer(filters, Collections.emptySet());
        }
        return new MaxScoreBulkScorer(this.maxDoc, optionalScorers, (Scorer)var5_8);
    }

    private BulkScorer requiredBulkScorer() throws IOException {
        Scorer conjunctionScorer;
        if (this.subs.get((Object)BooleanClause.Occur.MUST).size() + this.subs.get((Object)BooleanClause.Occur.FILTER).size() == 0) {
            return null;
        }
        if (this.subs.get((Object)BooleanClause.Occur.MUST).size() + this.subs.get((Object)BooleanClause.Occur.FILTER).size() == 1) {
            BulkScorer scorer;
            if (!this.subs.get((Object)BooleanClause.Occur.MUST).isEmpty()) {
                scorer = this.subs.get((Object)BooleanClause.Occur.MUST).iterator().next().bulkScorer();
            } else {
                scorer = this.subs.get((Object)BooleanClause.Occur.FILTER).iterator().next().bulkScorer();
                if (this.scoreMode.needsScores()) {
                    scorer = BooleanScorerSupplier.disableScoring(scorer);
                }
            }
            return scorer;
        }
        long leadCost = this.subs.get((Object)BooleanClause.Occur.MUST).stream().mapToLong(ScorerSupplier::cost).min().orElse(Long.MAX_VALUE);
        leadCost = this.subs.get((Object)BooleanClause.Occur.FILTER).stream().mapToLong(ScorerSupplier::cost).min().orElse(leadCost);
        ArrayList<Scorer> requiredNoScoring = new ArrayList<Scorer>();
        for (ScorerSupplier ss : this.subs.get((Object)BooleanClause.Occur.FILTER)) {
            requiredNoScoring.add(ss.get(leadCost));
        }
        List<Scorer> requiredScoring = new ArrayList<Scorer>();
        Collection<ScorerSupplier> requiredScoringSupplier = this.subs.get((Object)BooleanClause.Occur.MUST);
        for (ScorerSupplier ss : requiredScoringSupplier) {
            if (requiredScoringSupplier.size() == 1) {
                ss.setTopLevelScoringClause();
            }
            requiredScoring.add(ss.get(leadCost));
        }
        if (this.scoreMode == ScoreMode.TOP_SCORES && requiredScoring.size() > 1 && requiredNoScoring.stream().map(Scorer::twoPhaseIterator).allMatch(Objects::isNull) && requiredScoring.stream().map(Scorer::twoPhaseIterator).allMatch(Objects::isNull)) {
            for (Scorer filter : requiredNoScoring) {
                requiredScoring.add(new ConstantScoreScorer(0.0f, ScoreMode.COMPLETE, filter.iterator()));
            }
            return new BlockMaxConjunctionBulkScorer(this.maxDoc, requiredScoring);
        }
        if (this.scoreMode != ScoreMode.TOP_SCORES && requiredScoring.size() + requiredNoScoring.size() >= 2 && requiredScoring.stream().map(Scorer::twoPhaseIterator).allMatch(Objects::isNull) && requiredNoScoring.stream().map(Scorer::twoPhaseIterator).allMatch(Objects::isNull)) {
            return new ConjunctionBulkScorer(requiredScoring, requiredNoScoring);
        }
        if (this.scoreMode == ScoreMode.TOP_SCORES && requiredScoring.size() > 1) {
            requiredScoring = Collections.singletonList(new BlockMaxConjunctionScorer(requiredScoring));
        }
        if (requiredNoScoring.size() + requiredScoring.size() == 1) {
            if (requiredScoring.size() == 1) {
                conjunctionScorer = requiredScoring.get(0);
            } else {
                conjunctionScorer = (Scorer)requiredNoScoring.get(0);
                if (this.scoreMode.needsScores()) {
                    Scorer inner = conjunctionScorer;
                    conjunctionScorer = new FilterScorer(this, inner){

                        @Override
                        public float score() throws IOException {
                            return 0.0f;
                        }

                        @Override
                        public float getMaxScore(int upTo) throws IOException {
                            return 0.0f;
                        }
                    };
                }
            }
        } else {
            ArrayList<Scorer> required = new ArrayList<Scorer>();
            required.addAll(requiredScoring);
            required.addAll(requiredNoScoring);
            conjunctionScorer = new ConjunctionScorer(required, requiredScoring);
        }
        return new Weight.DefaultBulkScorer(conjunctionScorer);
    }

    private Scorer req(Collection<ScorerSupplier> requiredNoScoring, Collection<ScorerSupplier> requiredScoring, long leadCost, boolean topLevelScoringClause) throws IOException {
        if (requiredNoScoring.size() + requiredScoring.size() == 1) {
            Scorer req = (requiredNoScoring.isEmpty() ? requiredScoring : requiredNoScoring).iterator().next().get(leadCost);
            if (!this.scoreMode.needsScores()) {
                return req;
            }
            if (requiredScoring.isEmpty()) {
                return new FilterScorer(this, req){

                    @Override
                    public float score() throws IOException {
                        return 0.0f;
                    }

                    @Override
                    public float getMaxScore(int upTo) throws IOException {
                        return 0.0f;
                    }
                };
            }
            return req;
        }
        ArrayList<Scorer> requiredScorers = new ArrayList<Scorer>();
        List<Scorer> scoringScorers = new ArrayList<Scorer>();
        for (ScorerSupplier s : requiredNoScoring) {
            requiredScorers.add(s.get(leadCost));
        }
        for (ScorerSupplier s : requiredScoring) {
            Scorer scorer = s.get(leadCost);
            scoringScorers.add(scorer);
        }
        if (this.scoreMode == ScoreMode.TOP_SCORES && scoringScorers.size() > 1 && topLevelScoringClause) {
            BlockMaxConjunctionScorer blockMaxScorer = new BlockMaxConjunctionScorer(scoringScorers);
            if (requiredScorers.isEmpty()) {
                return blockMaxScorer;
            }
            scoringScorers = Collections.singletonList(blockMaxScorer);
        }
        requiredScorers.addAll(scoringScorers);
        return new ConjunctionScorer(requiredScorers, scoringScorers);
    }

    private Scorer excl(Scorer main, Collection<ScorerSupplier> prohibited, long leadCost) throws IOException {
        if (prohibited.isEmpty()) {
            return main;
        }
        return new ReqExclScorer(main, this.opt(prohibited, 1, ScoreMode.COMPLETE_NO_SCORES, leadCost, false));
    }

    private Scorer opt(Collection<ScorerSupplier> optional, int minShouldMatch, ScoreMode scoreMode, long leadCost, boolean topLevelScoringClause) throws IOException {
        if (optional.size() == 1) {
            return optional.iterator().next().get(leadCost);
        }
        ArrayList<Scorer> optionalScorers = new ArrayList<Scorer>();
        for (ScorerSupplier scorer : optional) {
            optionalScorers.add(scorer.get(leadCost));
        }
        if (scoreMode == ScoreMode.TOP_SCORES && topLevelScoringClause || minShouldMatch > 1) {
            return new WANDScorer(optionalScorers, minShouldMatch, scoreMode, leadCost);
        }
        return new DisjunctionSumScorer(optionalScorers, scoreMode);
    }
}

